"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var bt = __importStar(require("@babel/types"));
function getTypeFromAnnotation(typeNode) {
    if (typeNode) {
        if (bt.isTSTypeAnnotation(typeNode)) {
            return getTypeObjectFromTSType(typeNode.typeAnnotation);
        }
        else if (bt.isTypeAnnotation(typeNode)) {
            return getTypeObjectFromFlowType(typeNode.typeAnnotation);
        }
    }
    return undefined;
}
exports.default = getTypeFromAnnotation;
var TS_TYPE_NAME_MAP = {
    TSAnyKeyword: 'any',
    TSUnknownKeyword: 'unknown',
    TSNumberKeyword: 'number',
    TSObjectKeyword: 'object',
    TSBooleanKeyword: 'boolean',
    TSStringKeyword: 'string',
    TSSymbolKeyword: 'symbol',
    TSVoidKeyword: 'void',
    TSUndefinedKeyword: 'undefined',
    TSNullKeyword: 'null',
    TSNeverKeyword: 'never'
};
function getTypeObjectFromTSType(type) {
    var name = bt.isTSTypeReference(type) && bt.isIdentifier(type.typeName)
        ? type.typeName.name
        : TS_TYPE_NAME_MAP[type.type]
            ? TS_TYPE_NAME_MAP[type.type]
            : type.type;
    return { name: name };
}
var FLOW_TYPE_NAME_MAP = {
    AnyTypeAnnotation: 'any',
    UnknownTypeAnnotation: 'unknown',
    NumberTypeAnnotation: 'number',
    ObjectTypeAnnotation: 'object',
    BooleanTypeAnnotation: 'boolean',
    StringTypeAnnotation: 'string',
    SymbolTypeAnnotation: 'symbol',
    VoidTypeAnnotation: 'void',
    UndefinedTypeAnnotation: 'undefined',
    NullTypeAnnotation: 'null',
    NeverTypeAnnotation: 'never'
};
function getTypeObjectFromFlowType(type) {
    var name = FLOW_TYPE_NAME_MAP[type.type]
        ? FLOW_TYPE_NAME_MAP[type.type]
        : bt.isGenericTypeAnnotation(type) && bt.isIdentifier(type.id)
            ? type.id.name
            : type.type;
    return { name: name };
}
