"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var bt = __importStar(require("@babel/types"));
var recast_1 = __importDefault(require("recast"));
var ts_map_1 = __importDefault(require("ts-map"));
var isExportedAssignment_1 = __importDefault(require("./isExportedAssignment"));
var resolveExportDeclaration_1 = __importDefault(require("./resolveExportDeclaration"));
var resolveIdentifier_1 = __importDefault(require("./resolveIdentifier"));
var resolveRequired_1 = __importDefault(require("./resolveRequired"));
function ignore() {
    return false;
}
/**
 * List of all keys that could contain documentation
 */
var VUE_COMPONENTS_KEYS = ['data', 'props', 'methods', 'computed'];
function isObjectExpressionComponentDefinition(node) {
    return (
    // export const test = {}
    node.properties.length === 0 ||
        // export const compo = {data(){ return {cpm:"Button"}}
        node.properties.some(function (p) {
            return (bt.isObjectMethod(p) || bt.isObjectProperty(p)) && VUE_COMPONENTS_KEYS.includes(p.key.name);
        }));
}
function isComponentDefinition(path) {
    var node = path.node;
    return (
    // export default {} (always exported even when empty)
    bt.isObjectExpression(node) ||
        // export const myComp = {} (exported only when there is a componente definition or if empty)
        (bt.isVariableDeclarator(node) &&
            node.init &&
            bt.isObjectExpression(node.init) &&
            isObjectExpressionComponentDefinition(node.init)) ||
        // export default class MyComp extends VueComp
        bt.isClassDeclaration(node) ||
        // export default whatever.extend({})
        (bt.isCallExpression(node) && bt.isObjectExpression(node.arguments[0])));
}
/**
 * Given an AST, this function tries to find the exported component definitions.
 *
 * If a definition is part of the following statements, it is considered to be
 * exported:
 *
 * modules.exports = Definition;
 * exports.foo = Definition;
 * export default Definition;
 * export var Definition = ...;
 */
function resolveExportedComponent(ast) {
    var components = new ts_map_1.default();
    var nonComponentsIdentifiers = [];
    function setComponent(exportName, definition) {
        if (definition && !components.get(exportName)) {
            components.set(exportName, normalizeComponentPath(definition));
        }
    }
    // function run for every non "assignment" export declaration
    // in extenso export default or export myvar
    function exportDeclaration(path) {
        var definitions = resolveExportDeclaration_1.default(path);
        definitions.forEach(function (definition, name) {
            var realDef = resolveIdentifier_1.default(ast, definition);
            if (realDef) {
                if (isComponentDefinition(realDef)) {
                    setComponent(name, realDef);
                }
            }
            else {
                nonComponentsIdentifiers.push(definition.value.name);
            }
        });
        return false;
    }
    recast_1.default.visit(ast.program, {
        // for perf resons,
        // look only at the root,
        // ignore all traversing except for if
        visitFunctionDeclaration: ignore,
        visitFunctionExpression: ignore,
        visitClassDeclaration: ignore,
        visitClassExpression: ignore,
        visitWithStatement: ignore,
        visitSwitchStatement: ignore,
        visitWhileStatement: ignore,
        visitDoWhileStatement: ignore,
        visitForStatement: ignore,
        visitForInStatement: ignore,
        visitDeclareExportDeclaration: exportDeclaration,
        visitExportNamedDeclaration: exportDeclaration,
        visitExportDefaultDeclaration: exportDeclaration,
        visitAssignmentExpression: function (path) {
            // function run on every assignments (with an =)
            // Ignore anything that is not `exports.X = ...;` or
            // `module.exports = ...;`
            if (!isExportedAssignment_1.default(path)) {
                return false;
            }
            // Resolve the value of the right hand side. It should resolve to a call
            // expression, something like Vue.extend({})
            var pathRight = path.get('right');
            var pathLeft = path.get('left');
            var realComp = resolveIdentifier_1.default(ast, pathRight);
            var name = bt.isMemberExpression(pathLeft.node) &&
                bt.isIdentifier(pathLeft.node.property) &&
                pathLeft.node.property.name !== 'exports'
                ? pathLeft.node.property.name
                : 'default';
            if (realComp) {
                if (isComponentDefinition(realComp)) {
                    setComponent(name, realComp);
                }
            }
            else {
                nonComponentsIdentifiers.push(name);
            }
            return false;
        }
    });
    var requiredValues = resolveRequired_1.default(ast, nonComponentsIdentifiers);
    return [components, requiredValues];
}
exports.default = resolveExportedComponent;
function normalizeComponentPath(path) {
    if (bt.isObjectExpression(path.node)) {
        return path;
    }
    else if (bt.isCallExpression(path.node)) {
        return path.get('arguments', 0);
    }
    else if (bt.isVariableDeclarator(path.node)) {
        return path.get('init');
    }
    return path;
}
