"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var join = require('path').join;
var SUFFIXES = ['', '.js', '.ts', '.vue', '.jsx', '.tsx'];
function resolvePathFrom(path, from) {
    var finalPath = '';
    SUFFIXES.forEach(function (s) {
        if (!finalPath.length) {
            try {
                finalPath = require.resolve("" + path + s, {
                    paths: from
                });
            }
            catch (e) {
                // eat the error
            }
        }
        if (!finalPath.length) {
            try {
                finalPath = require.resolve(join(path, "index" + s), {
                    paths: from
                });
            }
            catch (e) {
                // eat the error
            }
        }
        if (!finalPath.length) {
            for (var i = 0; i < from.length; i++) {
                try {
                    finalPath = require.resolve(join(from[i], "" + path + s));
                    if (finalPath.length) {
                        break;
                    }
                }
                catch (e) {
                    // eat the error
                }
            }
        }
    });
    try {
        var packagePath = require.resolve(join(path, 'package.json'), {
            paths: from
        });
        var pkg = require(packagePath);
        // if it is an es6 module use the module instead of commonjs
        finalPath = require.resolve(join(path, pkg.module || pkg.main));
    }
    catch (e) {
        // eat the error
    }
    if (!finalPath.length) {
        // eslint-disable-next-line no-console
        console.warn("Neither '" + path + ".vue' nor '" + path + ".js(x)' or '" + path + "/index.js(x)' or '" + path + "/index.ts(x)' could be found in '" + from + "'");
    }
    return finalPath;
}
exports.default = resolvePathFrom;
