"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var blockTags_1 = __importDefault(require("./blockTags"));
function transformTagsIntoObject(tags) {
    return tags.reduce(function (acc, tag) {
        if (blockTags_1.default.indexOf(tag.title) > -1) {
            if (isContentTag(tag)) {
                var newTag = {
                    description: tag.content,
                    title: tag.title
                };
                tag = newTag;
            }
            var title = tag.title === 'param' ? 'params' : tag.title;
            if (acc[title]) {
                acc[title].push(tag);
            }
            else {
                acc[title] = [tag];
            }
        }
        return acc;
    }, {});
}
exports.default = transformTagsIntoObject;
function isContentTag(tag) {
    return tag.content !== undefined;
}
