<!--
* Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
*
* WSO2 Inc. licenses this file to you under the Apache License,
* Version 2.0 (the "License"); you may not use this file except
* in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing,
* software distributed under the License is distributed on an
* "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
* KIND, either express or implied. See the License for the
* specific language governing permissions and limitations
* under the License.
-->

<%@ page import="static org.wso2.carbon.identity.core.util.IdentityUtil.getServerURL" %>
<%@ page import="static org.wso2.carbon.utils.multitenancy.MultitenantConstants.TENANT_AWARE_URL_PREFIX"%>
<%@ page import="static org.wso2.carbon.utils.multitenancy.MultitenantConstants.SUPER_TENANT_DOMAIN_NAME"%>

<!DOCTYPE HTML>
<html>
    <head>
        <%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
        <meta charset="utf-8"/>
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no"/>
        <meta name="referrer" content="no-referrer" />

        <link href="/admin-portal/libs/themes/default/theme.min.css" rel="stylesheet" type="text/css"/>

        <title>WSO2 Identity Server</title>

        <!-- runtime config -->
        <script src="/admin-portal/runtime-config.js"></script>
        <!-- runtime config -->

        <script>
            var getTenantPrefix = function() {
                return "<%=TENANT_AWARE_URL_PREFIX%>";
            };

            var getSuperTenant = function() {
                return "<%=SUPER_TENANT_DOMAIN_NAME%>";
            };

            var getTenantName = function() {
                var paths = window.location.pathname.split("/");
                var tenantIndex = paths.indexOf(getTenantPrefix());

                if (tenantIndex > 0) {
                    var tenantName = paths[tenantIndex + 1];
                    return (tenantName) ? tenantName : "";
                } else {
                    return "";
                }
            };

            var getTenantPath = function(tenantName) {
                return (tenantName !== "") ? "/" + getTenantPrefix() + "/" + tenantName : "";
            };

            /**
            * =====================================================
            * Configure your portal settings
            * =====================================================
            */

            // Add applications which are not to be deleted in to this array.
            var doNotDeleteApplications = ["Admin Portal", "User Portal"];

            /**
             * =====================================================
             * Update below details according to your configuration
             * =====================================================
             */

            // Update below with tenant admin-portal application/service-provider details
            var serverOriginAddress = "<%=getServerURL("", true, true)%>";
            var clientOriginAddress = "<%=getServerURL("", true, true)%>";

            var tenantName = getTenantName();
            var defaultAdminPortalClientID = "ADMIN_PORTAL";
            var tenantAdminPortalClientID = defaultAdminPortalClientID + "_" + tenantName;

            var defaultUserPortalClientHost = serverOriginAddress + getTenantPath(tenantName);
            var defaultUserPortalBaseName = "user-portal";
            var defaultMyAccountPath = "/personal-info";

            /** ===================================================== */

            if (!window.userConfig) {
                window.userConfig = {};
            }

            window["runConfig"] = {
                appBaseName: window.userConfig.appBaseName || getTenantPath(tenantName) + 
                    "/admin-portal",
                appBaseNameWithoutTenant: window.userConfig.appBaseNameWithoutTenant ||
                    "/admin-portal",
                clientHost: window.userConfig.clientHost || clientOriginAddress + getTenantPath(tenantName),
                clientOrigin: window.userConfig.clientOrigin || clientOriginAddress,
                clientID: window.userConfig.clientID ||
                    (getTenantPath(tenantName) === ("/" + getTenantPrefix() + "/" + tenantName)) ?
                    tenantAdminPortalClientID : defaultAdminPortalClientID,
                doNotDeleteApplications: doNotDeleteApplications || [],
                myAccountPath: window.userConfig.myAccountPath || defaultMyAccountPath,
                serverHost: window.userConfig.serverHost || serverOriginAddress + getTenantPath(tenantName),
                serverOrigin: window.userConfig.serverOrigin || serverOriginAddress,
                tenant: window.userConfig.tenant || (tenantName === "") ? getSuperTenant() : tenantName,
                tenantPath: window.userConfig.tenantPath || getTenantPath(tenantName),
                userPortalBaseName: window.userConfig.userPortalBaseName || defaultUserPortalBaseName,
                userPortalClientHost: window.userConfig.userPortalClientHost || defaultUserPortalClientHost
            };
        </script>
    <link rel="shortcut icon" href="/admin-portal/favicon.ico"></head>
    <body>
        <noscript>
            You need to enable JavaScript to run this app.
        </noscript>
        <div id="root"></div>
    <script type="text/javascript" src="/admin-portal/main.js?6702f11eda2f6176617c"></script></body>
</html>
