/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import { EmptyPlaceholder, LinkButton } from "@wso2is/react-components";
import React, { ReactElement } from "react";
import { useTranslation } from "react-i18next";
import { Link } from "react-router-dom";
import { EmptyPlaceholderIllustrations } from "../../configs";

/**
 * Unauthorized error page.
 *
 * @return {React.ReactElement}
 */
export const UnauthorizedErrorPage = (): ReactElement => {

    const { t } = useTranslation();

    return (
        <EmptyPlaceholder
            action={ (
                <LinkButton as={ Link } to={ APP_LOGOUT_PATH }>
                    { t("devPortal:placeholders.loginError.action") }
                </LinkButton>
            ) }
            image={ EmptyPlaceholderIllustrations.loginError }
            imageSize="tiny"
            subtitle={ [
                t("devPortal:placeholders.loginError.subtitles.0"),
                t("devPortal:placeholders.loginError.subtitles.1")
            ] }
            title={ t("devPortal:placeholders.loginError.title") }
        />
    );
};
