/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { LinkedAccountInterface, ProfileInfoInterface, ProfileSchemaInterface } from "../models";
/**
 * Retrieve the user information of the currently authenticated user.
 *
 * @return {Promise<ProfileInfoInterface>} User information as a Promise.
 */
export declare const getUserInfo: () => Promise<ProfileInfoInterface>;
/**
 *  Get Gravatar image using the email address.
 *
 * @param email - Email address.
 * @return {Promise<string>} Valid Gravatar URL as a Promise.
 */
export declare const getGravatarImage: (email: string) => Promise<string>;
/**
 * Retrieve the user profile details of the currently authenticated user.
 *
 * @param {() => void} onSCIMDisabled - Callback to be fired if SCIM is disabled for the user store.
 * @returns {Promise<ProfileInfoInterface>} Profile information as a Promise.
 */
export declare const getProfileInfo: (onSCIMDisabled: () => void) => Promise<ProfileInfoInterface>;
/**
 * Update the required details of the user profile.
 *
 * @param {object} info - Information that needs to ber updated.
 * @return {Promise<ProfileInfoInterface>} Updated profile info as a Promise.
 */
export declare const updateProfileInfo: (info: object) => Promise<ProfileInfoInterface>;
/**
 * Retrieve the profile schemas of the user claims of the currently authenticated user.
 *
 * @return {Promise<ProfileSchemaInterface[]>} Array of profile schemas as a Promise.
 */
export declare const getProfileSchemas: () => Promise<ProfileSchemaInterface[]>;
/**
 * Switches the logged in user's account to one of the linked accounts
 * associated to the corresponding user.
 *
 * @param {LinkedAccountInterface} account - The target account.
 * @param {string[]} scopes - Required scopes array.
 * @param {string} clientID - Client ID.
 * @param {string} clientHost - Client Host URL.
 * @return {Promise<any>}
 */
export declare const switchAccount: (account: LinkedAccountInterface, scopes: string[], clientID: string, clientHost: string) => Promise<any>;
