/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { ResetAuthenticationActionInterface, SetSignInActionInterface, SetSignOutActionInterface } from "./types";
/**
 * Redux action to set sign in.
 *
 * @return {SetSignInActionInterface} An action of type `SET_SIGN_IN`
 */
export declare const setSignIn: () => SetSignInActionInterface;
/**
 * Redux action to set sign out.
 *
 * @return {SetSignOutActionInterface} An action of type `SET_SIGN_OUT`
 */
export declare const setSignOut: () => SetSignOutActionInterface;
/**
 * Redux action to reset authentication.
 *
 * @return {ResetAuthenticationActionInterface} An action of type `RESET_AUTHENTICATION`
 */
export declare const resetAuthentication: () => ResetAuthenticationActionInterface;
/**
 * Redux action to handle user sign in.
 *
 * @param {string} clientID - Client ID.
 * @param {string} clientHost - Client Host URL.
 * @param {string} redirectURI - URL to be redirected once sign in is successful.
 * @param {string[]} scopes - Required scopes array.
 * @param {boolean} consentDenied - Flag to determine if the consent has been given to the application.
 * @return {(dispatch) => void}
 */
export declare const handleSignIn: (clientID: string, clientHost: string, redirectURI: string, scopes: string[], consentDenied?: boolean) => (dispatch: any) => void;
/**
 * Redux action to handle user sign-out.
 *
 * @param {string} callbackURL - Login callback URL.
 * @return {(dispatch) => void}
 */
export declare const handleSignOut: (callbackURL: string) => (dispatch: any) => void;
/**
 * Redux action to end the authenticated user session.
 * This will clear the session related information and sign out from the session.
 *
 * @param {() => void} onSuccess - Callback to be fired on successful session end.
 * @param {(error: Error) => void} onError - Callback to be fired on session end error.
 */
export declare const endUserSession: (onSuccess: () => void, onError: (error: Error) => void) => (dispatch: any) => void;
