/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import classNames from "classnames";
import React from "react";
import { Card, Divider, Label, Popup } from "semantic-ui-react";
import { GenericIcon } from "../icon";
/**
 * Template card component that can be used to represent application and IDP templates.
 *
 * @param {TemplateCardPropsInterface} props - Props injected to the components.
 *
 * @return {React.ReactElement}
 */
export const TemplateCard = (props) => {
    const { className, description, disabled, name, id, inline, image, imageSize, onClick, selected, tags, tagsAs, tagsSectionTitle, textAlign } = props;
    const classes = classNames("template-card", {
        disabled,
        ["with-image"]: image,
        inline,
        selected
    }, className);
    return (React.createElement(Card, { id: id, className: classes, onClick: onClick, link: false, as: "div" },
        image && (React.createElement(Card.Content, { className: "card-image-container" },
            React.createElement(GenericIcon, { className: "card-image", size: imageSize, icon: image, square: true, transparent: true }))),
        React.createElement(Card.Content, { className: "card-text-container", style: { textAlign } },
            React.createElement(Card.Header, null, name),
            React.createElement(Card.Description, null, description),
            (tags && tags instanceof Array && tags.length > 0)
                ? (React.createElement("div", { className: "tags" },
                    React.createElement("div", { className: "title" }, tagsSectionTitle),
                    React.createElement("div", { className: "logos" }, tags.map((tag, index) => (tagsAs === "icon"
                        ? (React.createElement(Popup, { basic: true, key: index, trigger: (React.createElement("span", { className: "icon-wrapper" },
                                React.createElement(GenericIcon, { icon: tag.logo, size: "micro", spaced: "right", inline: true, transparent: true }))), size: "mini", position: "top center", content: tag.displayName, inverted: true }))
                        : React.createElement(Label, { size: "mini" }, tag.displayName))))))
                : React.createElement(Divider, { hidden: true }))));
};
/**
 * Default props for the application template card.
 */
TemplateCard.defaultProps = {
    imageSize: "tiny",
    inline: true,
    tagsAs: "label",
    textAlign: "center"
};
//# sourceMappingURL=template-card.js.map