/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from "react";
import { Checkbox, Table } from "semantic-ui-react";
import { EmptyPlaceholder } from "../placeholder";
/**
 * Transfer list component.
 *
 * @param {TransferListProps} props - Props injected to the component.
 * @return {React.ReactElement}
 */
export const TransferList = (props) => {
    const { children, className, rest, listValues, listHeaders, isListEmpty, handleHeaderCheckboxChange, isHeaderCheckboxChecked } = props;
    return (React.createElement(React.Fragment, null, !isListEmpty ? (React.createElement(Table, null,
        listHeaders instanceof Array && (React.createElement(Table.Header, null,
            React.createElement(Table.Row, null,
                React.createElement(Table.HeaderCell, null,
                    React.createElement(Checkbox, { "data-testid": props[`data-testid`], checked: isHeaderCheckboxChecked, onChange: handleHeaderCheckboxChange })), listHeaders === null || listHeaders === void 0 ? void 0 :
                listHeaders.map((header, index) => {
                    return (React.createElement(Table.HeaderCell, { key: index },
                        React.createElement("strong", null, header)));
                })))),
        children)) : (React.createElement("div", { className: "empty-placeholder-center" },
        React.createElement(EmptyPlaceholder, { subtitle: ["There are no items in this list at the moment."] })))));
};
//# sourceMappingURL=tansfer-list.js.map