import { GenericIconProps } from "../icon";
import { SemanticICONS, SidebarProps } from "semantic-ui-react";
import { ForwardRefExoticComponent, PropsWithoutRef, ReactNode, RefAttributes } from "react";
import { HelpPanelActionBar } from "./help-panel-action-bar";
/**
 * Component ref type.
 */
export declare type HelpPanelRefType = HTMLDivElement;
/**
 * Help side panel component sub component.
 */
export interface HelpPanelSubComponentsInterface {
    ActionBar: typeof HelpPanelActionBar;
}
/**
 * Help panel interface.
 */
export interface HelpPanelPropsInterface extends SidebarProps {
    /**
     * Set of actions for the top action bar.
     */
    actions: GenericIconProps[];
    /**
     * Array of objects describing tabs.
     */
    tabs: HelpPanelTabInterface[];
    /**
     * Is mini sidebar enabled.
     */
    sidebarMiniEnabled?: boolean;
    /**
     * Callback to be called on sidebar toggle.
     */
    onSidebarToggle: () => void;
    /**
     * Called on sidebar mini item click.
     * @param {string} item - Clicked on item.
     */
    onSidebarMiniItemClick?: (item: string) => void;
    /**
     * Initial tabs active index.
     */
    tabsActiveIndex?: number;
}
/**
 * Help panel component Prop types.
 */
export interface HelpPanelComponentPropsInterface extends HelpPanelPropsInterface, HelpPanelSubComponentsInterface {
}
/**
 * Help panel tab interface.
 */
export interface HelpPanelTabInterface {
    heading: any;
    hidden: boolean;
    content: ReactNode;
    icon: SemanticICONS;
}
/**
 * Help side panel.
 *
 * @param {React.PropsWithChildren<HelpPanelComponentPropsInterface>} props - Props injected to the component.
 * @return {React.ReactElement}
 */
export declare const HelpPanel: ForwardRefExoticComponent<PropsWithoutRef<HelpPanelComponentPropsInterface> & RefAttributes<HelpPanelRefType>> & any;
