/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { PropsWithChildren } from "react";
import { SemanticVERTICALALIGNMENTS } from "semantic-ui-react";
/**
 * Proptypes for the Generic Icon component.
 */
export interface GenericIconProps {
    bordered?: boolean;
    className?: string;
    colored?: boolean;
    defaultIcon?: boolean;
    floated?: string;
    hoverable?: boolean;
    icon: any;
    inline?: boolean;
    link?: boolean;
    linkType?: "primary";
    onClick?: (event: React.MouseEvent<HTMLDivElement>) => void;
    relaxed?: boolean | "very";
    rounded?: boolean;
    size?: GenericIconSizes;
    spaced?: "left" | "right";
    style?: object;
    square?: boolean;
    transparent?: boolean;
    twoTone?: boolean;
    verticalAlign?: SemanticVERTICALALIGNMENTS;
}
export declare type GenericIconSizes = "auto" | "nano" | "default" | "micro" | "mini" | "tiny" | "small" | "medium" | "large" | "big" | "huge" | "massive";
/**
 * Generic component to render icons.
 *
 * @param {GenericIconProps} props - Props injected to the component.
 * @return {JSX.Element}
 */
export declare const GenericIcon: React.FunctionComponent<PropsWithChildren<GenericIconProps>>;
