"use strict";

require("core-js/modules/es.object.assign");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _global = require("global");

var _addons = require("@storybook/addons");

var _parameters = _interopRequireDefault(require("./parameters"));

var _styles = _interopRequireDefault(require("./styles"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function centered(storyFn) {
  var _storyFn = storyFn(),
      template = _storyFn.template,
      context = _storyFn.context;

  var element = _global.document.createElement('div');

  Object.assign(element.style, _styles["default"].style);

  var innerElement = _global.document.createElement('div');

  Object.assign(innerElement.style, _styles["default"].innerStyle);
  element.appendChild(innerElement); // the inner element should append the parent

  innerElement.appendTo = function appendTo(el) {
    el.appendChild(element);
  };

  return {
    template: template,
    context: context,
    element: innerElement
  };
}

var _default = (0, _addons.makeDecorator)(Object.assign({}, _parameters["default"], {
  wrapper: function wrapper(getStory) {
    return centered(getStory);
  }
}));

exports["default"] = _default;

if (module && module.hot && module.hot.decline) {
  module.hot.decline();
}