"use strict";

require("core-js/modules/es.object.assign");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _addons = require("@storybook/addons");

var _Centered = _interopRequireDefault(require("./components/Centered.svelte"));

var _styles = _interopRequireDefault(require("./styles"));

var _json2CSS = _interopRequireDefault(require("./helpers/json2CSS"));

var _parameters = _interopRequireDefault(require("./parameters"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var centeredStyles = {
  /** @type {string} */
  style: (0, _json2CSS["default"])(_styles["default"].style),

  /** @type {string} */
  innerStyle: (0, _json2CSS["default"])(_styles["default"].innerStyle)
};
/**
 * This functionality works by passing the svelte story component into another
 * svelte component that has the single purpose of centering the story component
 * using a wrapper and container.
 *
 * We use the special element <svelte:component /> to achieve this.
 *
 * @see https://svelte.technology/guide#svelte-component
 */

function centered(storyFn) {
  var _storyFn = storyFn(),
      OriginalComponent = _storyFn.Component,
      props = _storyFn.props,
      on = _storyFn.on;

  return {
    Component: OriginalComponent,
    props: props,
    on: on,
    Wrapper: _Centered["default"],
    WrapperData: centeredStyles
  };
}

var _default = (0, _addons.makeDecorator)(Object.assign({}, _parameters["default"], {
  wrapper: function wrapper(getStory) {
    return centered(getStory);
  }
}));

exports["default"] = _default;

if (module && module.hot && module.hot.decline) {
  module.hot.decline();
}