"use strict";

require("core-js/modules/es.symbol");

require("core-js/modules/es.symbol.description");

require("core-js/modules/es.symbol.iterator");

require("core-js/modules/es.array.filter");

require("core-js/modules/es.array.for-each");

require("core-js/modules/es.array.includes");

require("core-js/modules/es.array.is-array");

require("core-js/modules/es.array.iterator");

require("core-js/modules/es.array.map");

require("core-js/modules/es.date.to-string");

require("core-js/modules/es.function.name");

require("core-js/modules/es.object.assign");

require("core-js/modules/es.object.define-property");

require("core-js/modules/es.object.entries");

require("core-js/modules/es.object.keys");

require("core-js/modules/es.object.to-string");

require("core-js/modules/es.regexp.to-string");

require("core-js/modules/es.string.includes");

require("core-js/modules/es.string.iterator");

require("core-js/modules/web.dom-collections.for-each");

require("core-js/modules/web.dom-collections.iterator");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Props = exports.getComponent = exports.getComponentProps = void 0;

var _react = _interopRequireWildcard(require("react"));

var _lodash = require("lodash");

var _components = require("@storybook/components");

var _DocsContext = require("./DocsContext");

var _shared = require("./shared");

var _utils = require("./utils");

var _extractProps = require("../frameworks/react/extractProps");

var _extractProps2 = require("../frameworks/vue/extractProps");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

// FIXME: remove in SB6.0 & require config
var inferPropsExtractor = function inferPropsExtractor(framework) {
  switch (framework) {
    case 'react':
      return _extractProps.extractProps;

    case 'vue':
      return _extractProps2.extractProps;

    default:
      return null;
  }
};

var filterRows = function filterRows(rows, exclude) {
  return rows && rows.filter(function (row) {
    return !exclude.includes(row.name);
  });
};

var getComponentProps = function getComponentProps(component, _ref, _ref2) {
  var exclude = _ref.exclude;
  var parameters = _ref2.parameters;

  if (!component) {
    return null;
  }

  try {
    var params = parameters || {};
    var _params$framework = params.framework,
        framework = _params$framework === void 0 ? null : _params$framework;

    var _ref3 = params.docs || {},
        _ref3$extractProps = _ref3.extractProps,
        extractProps = _ref3$extractProps === void 0 ? inferPropsExtractor(framework) : _ref3$extractProps;

    if (!extractProps) {
      throw new Error(_components.PropsTableError.PROPS_UNSUPPORTED);
    }

    var props = extractProps(component);

    if (!(0, _lodash.isNil)(exclude)) {
      var _ref4 = props,
          rows = _ref4.rows;
      var _ref5 = props,
          sections = _ref5.sections;

      if (rows) {
        props = {
          rows: filterRows(rows, exclude)
        };
      } else if (sections) {
        Object.keys(sections).forEach(function (section) {
          sections[section] = filterRows(sections[section], exclude);
        });
      }
    }

    return props;
  } catch (err) {
    return {
      error: err.message
    };
  }
};

exports.getComponentProps = getComponentProps;

var getComponent = function getComponent() {
  var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var context = arguments.length > 1 ? arguments[1] : undefined;
  var of = props.of;
  var _context$parameters = context.parameters,
      parameters = _context$parameters === void 0 ? {} : _context$parameters;
  var component = parameters.component;
  var target = of === _shared.CURRENT_SELECTION ? component : of;

  if (!target) {
    if (of === _shared.CURRENT_SELECTION) {
      return null;
    }

    throw new Error(_components.PropsTableError.NO_COMPONENT);
  }

  return target;
};

exports.getComponent = getComponent;

var PropsContainer = function PropsContainer(props) {
  var context = (0, _react.useContext)(_DocsContext.DocsContext);
  var slot = props.slot,
      components = props.components;
  var subcomponents = context.parameters.subcomponents;
  var allComponents = components;

  if (!allComponents) {
    var main = getComponent(props, context);
    var mainLabel = (0, _utils.getComponentName)(main);
    var mainProps = slot ? slot(context, main) : getComponentProps(main, props, context);

    if (!subcomponents || _typeof(subcomponents) !== 'object') {
      return mainProps && _react["default"].createElement(_components.PropsTable, mainProps);
    }

    allComponents = Object.assign(_defineProperty({}, mainLabel, main), subcomponents);
  }

  var tabs = [];
  Object.entries(allComponents).forEach(function (_ref6) {
    var _ref7 = _slicedToArray(_ref6, 2),
        label = _ref7[0],
        component = _ref7[1];

    tabs.push({
      label: label,
      table: slot ? slot(context, component) : getComponentProps(component, props, context)
    });
  });
  return _react["default"].createElement(_components.TabsState, null, tabs.map(function (_ref8) {
    var label = _ref8.label,
        table = _ref8.table;

    if (!table) {
      return null;
    }

    var id = "prop_table_div_".concat(label);
    return _react["default"].createElement("div", {
      key: id,
      id: id,
      title: label
    }, function (_ref9) {
      var active = _ref9.active;
      return active ? _react["default"].createElement(_components.PropsTable, _extends({
        key: "prop_table_".concat(label)
      }, table)) : null;
    });
  }));
};

exports.Props = PropsContainer;
PropsContainer.defaultProps = {
  of: '.'
};