"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

require("core-js/modules/es.array.for-each");

require("core-js/modules/es.function.name");

require("core-js/modules/es.object.keys");

require("core-js/modules/web.dom-collections.for-each");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Story = exports.getStoryProps = exports.storyBlockIdFromId = void 0;

var _react = _interopRequireWildcard(require("react"));

var _react2 = require("@mdx-js/react");

var _html = require("@storybook/components/html");

var _components = require("@storybook/components");

var _csf = require("@storybook/csf");

var _shared = require("./shared");

var _DocsContext = require("./DocsContext");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var storyBlockIdFromId = function storyBlockIdFromId(storyId) {
  return "story--".concat(storyId);
};

exports.storyBlockIdFromId = storyBlockIdFromId;
var resetComponents = {};
Object.keys(_html.components).forEach(function (key) {
  resetComponents[key] = function (props) {
    return (0, _react.createElement)(key, props);
  };
});

var inferInlineStories = function inferInlineStories(framework) {
  switch (framework) {
    case 'react':
      return true;

    default:
      return false;
  }
};

var getStoryProps = function getStoryProps(props, _ref) {
  var currentId = _ref.id,
      storyStore = _ref.storyStore,
      mdxStoryNameToKey = _ref.mdxStoryNameToKey,
      mdxComponentMeta = _ref.mdxComponentMeta;
  var _ref2 = props,
      id = _ref2.id;
  var _ref3 = props,
      name = _ref3.name;
  var inputId = id === _shared.CURRENT_SELECTION ? currentId : id;
  var previewId = inputId || (0, _csf.toId)(mdxComponentMeta.id || mdxComponentMeta.title, (0, _csf.storyNameFromExport)(mdxStoryNameToKey[name]));
  var height = props.height,
      inline = props.inline;
  var data = storyStore.fromId(previewId);

  var _ref4 = data && data.parameters || {},
      _ref4$framework = _ref4.framework,
      framework = _ref4$framework === void 0 ? null : _ref4$framework;

  var docsParam = data && data.parameters && data.parameters.docs || {};

  if (docsParam.disable) {
    return null;
  } // prefer props, then global options, then framework-inferred values


  var _docsParam$inlineStor = docsParam.inlineStories,
      inlineStories = _docsParam$inlineStor === void 0 ? inferInlineStories(framework) : _docsParam$inlineStor,
      _docsParam$iframeHeig = docsParam.iframeHeight,
      iframeHeight = _docsParam$iframeHeig === void 0 ? undefined : _docsParam$iframeHeig,
      _docsParam$prepareFor = docsParam.prepareForInline,
      prepareForInline = _docsParam$prepareFor === void 0 ? undefined : _docsParam$prepareFor;

  var _ref5 = data || {},
      _ref5$storyFn = _ref5.storyFn,
      storyFn = _ref5$storyFn === void 0 ? undefined : _ref5$storyFn,
      _ref5$name = _ref5.name,
      storyName = _ref5$name === void 0 ? undefined : _ref5$name;

  var storyIsInline = typeof inline === 'boolean' ? inline : inlineStories;

  if (storyIsInline && !prepareForInline && framework !== 'react') {
    throw new Error("Story '".concat(storyName, "' is set to render inline, but no 'prepareForInline' function is implemented in your docs configuration!"));
  }

  return {
    inline: storyIsInline,
    id: previewId,
    storyFn: prepareForInline && storyFn ? function () {
      return prepareForInline(storyFn);
    } : storyFn,
    height: height || (storyIsInline ? undefined : iframeHeight),
    title: storyName
  };
};

exports.getStoryProps = getStoryProps;

var StoryContainer = function StoryContainer(props) {
  return _react["default"].createElement(_DocsContext.DocsContext.Consumer, null, function (context) {
    var storyProps = getStoryProps(props, context);

    if (!storyProps) {
      return null;
    }

    return _react["default"].createElement("div", {
      id: storyBlockIdFromId(storyProps.id)
    }, _react["default"].createElement(_react2.MDXProvider, {
      components: resetComponents
    }, _react["default"].createElement(_components.Story, storyProps)));
  });
};

exports.Story = StoryContainer;
StoryContainer.defaultProps = {
  children: null,
  name: null
};