"use strict";

require("core-js/modules/es.array.map");

require("core-js/modules/es.function.name");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.enhancePropTypesProp = enhancePropTypesProp;
exports.enhancePropTypesProps = enhancePropTypesProps;

var _lodash = require("lodash");

var _createType = require("./createType");

var _defaultValues = require("../lib/defaultValues");

var _sortProps = require("./sortProps");

var _rawDefaultPropResolvers = require("./rawDefaultPropResolvers");

function enhancePropTypesProp(extractedProp, rawDefaultProp) {
  var propDef = extractedProp.propDef;
  var newtype = (0, _createType.createType)(extractedProp);

  if (!(0, _lodash.isNil)(newtype)) {
    propDef.type = newtype;
  }

  var defaultValue = extractedProp.docgenInfo.defaultValue;

  if (!(0, _lodash.isNil)(defaultValue) && !(0, _lodash.isNil)(defaultValue.value)) {
    var newDefaultValue = (0, _defaultValues.createDefaultValue)(defaultValue.value);

    if (!(0, _lodash.isNil)(newDefaultValue)) {
      propDef.defaultValue = newDefaultValue;
    }
  } else if (!(0, _lodash.isNil)(rawDefaultProp)) {
    var _newDefaultValue = (0, _defaultValues.createDefaultValueFromRawDefaultProp)(rawDefaultProp, propDef, _rawDefaultPropResolvers.rawDefaultPropTypeResolvers);

    if (!(0, _lodash.isNil)(_newDefaultValue)) {
      propDef.defaultValue = _newDefaultValue;
    }
  }

  return propDef;
}

function enhancePropTypesProps(extractedProps, component) {
  var rawDefaultProps = !(0, _lodash.isNil)(component.defaultProps) ? component.defaultProps : {};
  var enhancedProps = extractedProps.map(function (x) {
    return enhancePropTypesProp(x, rawDefaultProps[x.propDef.name]);
  });
  return (0, _sortProps.keepOriginalDefinitionOrder)(enhancedProps, component);
}