"use strict";

require("core-js/modules/es.array.join");

require("core-js/modules/es.array.map");

require("core-js/modules/es.function.name");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createType = createType;

var _lodash = require("lodash");

var _utils = require("../../utils");

var FlowTypesType;

(function (FlowTypesType) {
  FlowTypesType["UNION"] = "union";
  FlowTypesType["SIGNATURE"] = "signature";
})(FlowTypesType || (FlowTypesType = {}));

function generateUnion(_ref) {
  var name = _ref.name,
      raw = _ref.raw,
      elements = _ref.elements;

  if (!(0, _lodash.isNil)(raw)) {
    return (0, _utils.createSummaryValue)(raw);
  }

  if (!(0, _lodash.isNil)(elements)) {
    return (0, _utils.createSummaryValue)(elements.map(function (x) {
      return x.value;
    }).join(' | '));
  }

  return (0, _utils.createSummaryValue)(name);
}

function generateFuncSignature(_ref2) {
  var type = _ref2.type,
      raw = _ref2.raw;

  if (!(0, _lodash.isNil)(raw)) {
    return (0, _utils.createSummaryValue)(raw);
  }

  return (0, _utils.createSummaryValue)(type);
}

function generateObjectSignature(_ref3) {
  var type = _ref3.type,
      raw = _ref3.raw;

  if (!(0, _lodash.isNil)(raw)) {
    return !(0, _utils.isTooLongForTypeSummary)(raw) ? (0, _utils.createSummaryValue)(raw) : (0, _utils.createSummaryValue)(type, raw);
  }

  return (0, _utils.createSummaryValue)(type);
}

function generateSignature(flowType) {
  var type = flowType.type;
  return type === 'object' ? generateObjectSignature(flowType) : generateFuncSignature(flowType);
}

function generateDefault(_ref4) {
  var name = _ref4.name,
      raw = _ref4.raw;

  if (!(0, _lodash.isNil)(raw)) {
    return !(0, _utils.isTooLongForTypeSummary)(raw) ? (0, _utils.createSummaryValue)(raw) : (0, _utils.createSummaryValue)(name, raw);
  }

  return (0, _utils.createSummaryValue)(name);
}

function createType(type) {
  // A type could be null if a defaultProp has been provided without a type definition.
  if ((0, _lodash.isNil)(type)) {
    return null;
  }

  switch (type.name) {
    case FlowTypesType.UNION:
      return generateUnion(type);

    case FlowTypesType.SIGNATURE:
      return generateSignature(type);

    default:
      return generateDefault(type);
  }
}