"use strict";

require("core-js/modules/es.symbol");

require("core-js/modules/es.symbol.description");

require("core-js/modules/es.symbol.iterator");

require("core-js/modules/es.array.is-array");

require("core-js/modules/es.array.iterator");

require("core-js/modules/es.array.map");

require("core-js/modules/es.object.create");

require("core-js/modules/es.object.define-property");

require("core-js/modules/es.object.get-prototype-of");

require("core-js/modules/es.object.set-prototype-of");

require("core-js/modules/es.object.to-string");

require("core-js/modules/es.string.iterator");

require("core-js/modules/web.dom-collections.iterator");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabsState = exports.Tabs = exports.panelProps = exports.TabWrapper = exports.TabBar = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _theming = require("@storybook/theming");

var _placeholder = require("../placeholder/placeholder");

var _bar = require("../bar/bar");

var _button = require("../bar/button");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var ignoreSsrWarning = '/* emotion-disable-server-rendering-unsafe-selector-warning-please-do-not-use-this-the-warning-exists-for-a-reason */';

var Wrapper = _theming.styled.div(function (_ref) {
  var theme = _ref.theme,
      bordered = _ref.bordered;
  return bordered ? {
    backgroundClip: 'padding-box',
    border: "1px solid ".concat(theme.appBorderColor),
    borderRadius: theme.appBorderRadius,
    overflow: 'hidden'
  } : {};
}, function (_ref2) {
  var absolute = _ref2.absolute;
  return absolute ? {
    width: '100%',
    height: '100%',
    boxSizing: 'border-box',
    display: 'flex',
    flexDirection: 'column'
  } : {
    display: 'block'
  };
});

var TabBar = _theming.styled.div({
  overflow: 'hidden',
  '&:first-of-type': {
    marginLeft: 0
  }
});

exports.TabBar = TabBar;

var Content = _theming.styled.div({
  display: 'block',
  position: 'relative'
}, function (_ref3) {
  var theme = _ref3.theme;
  return {
    fontSize: theme.typography.size.s2 - 1
  };
}, function (_ref4) {
  var absolute = _ref4.absolute;
  return absolute ? _defineProperty({
    height: 'calc(100% - 40px)',
    position: 'absolute',
    left: 0,
    right: 0,
    bottom: 0,
    top: 40,
    overflow: 'auto'
  }, "& > *:first-child".concat(ignoreSsrWarning), {
    position: 'absolute',
    left: 0,
    right: 0,
    bottom: 0,
    top: 0,
    height: '100%',
    overflow: 'auto'
  }) : {};
});

var VisuallyHidden = _theming.styled.div(function (_ref6) {
  var active = _ref6.active;
  return active ? {
    display: 'block'
  } : {
    display: 'none'
  };
});

var TabWrapper = function TabWrapper(_ref7) {
  var active = _ref7.active,
      render = _ref7.render,
      children = _ref7.children;
  return _react["default"].createElement(VisuallyHidden, {
    active: active
  }, render ? render() : children);
};

exports.TabWrapper = TabWrapper;
TabWrapper.displayName = "TabWrapper";
var panelProps = {
  active: _propTypes["default"].bool
};
exports.panelProps = panelProps;

var childrenToList = function childrenToList(children, selected) {
  return _react.Children.toArray(children).map(function (_ref8, index) {
    var _ref8$props = _ref8.props,
        title = _ref8$props.title,
        id = _ref8$props.id,
        color = _ref8$props.color,
        childrenOfChild = _ref8$props.children;
    var content = Array.isArray(childrenOfChild) ? childrenOfChild[0] : childrenOfChild;
    return {
      active: selected ? id === selected : index === 0,
      title: title,
      id: id,
      color: color,
      render: typeof content === 'function' ? content : function (_ref9) {
        var active = _ref9.active,
            key = _ref9.key;
        return _react["default"].createElement(VisuallyHidden, {
          key: key,
          active: active,
          role: "tabpanel"
        }, content);
      }
    };
  });
};

var _ref13 =
/*#__PURE__*/
_react["default"].createElement(_placeholder.Placeholder, null, _react["default"].createElement(_react.Fragment, {
  key: "title"
}, "Nothing found"));

var Tabs = (0, _react.memo)(function (_ref10) {
  var children = _ref10.children,
      selected = _ref10.selected,
      actions = _ref10.actions,
      absolute = _ref10.absolute,
      bordered = _ref10.bordered,
      tools = _ref10.tools,
      backgroundColor = _ref10.backgroundColor,
      htmlId = _ref10.id;
  var list = childrenToList(children, selected);
  return list.length ? _react["default"].createElement(Wrapper, {
    absolute: absolute,
    bordered: bordered,
    id: htmlId
  }, _react["default"].createElement(_bar.FlexBar, {
    border: true,
    backgroundColor: backgroundColor
  }, _react["default"].createElement(TabBar, {
    role: "tablist"
  }, list.map(function (_ref11) {
    var title = _ref11.title,
        id = _ref11.id,
        active = _ref11.active,
        color = _ref11.color;
    return _react["default"].createElement(_button.TabButton, {
      type: "button",
      key: id,
      active: active,
      textColor: color,
      onClick: function onClick(e) {
        e.preventDefault();
        actions.onSelect(id);
      },
      role: "tab",
      className: "tabbutton ".concat(active ? 'tabbutton-active' : '')
    }, typeof title === 'function' ? title() : title);
  })), tools ? _react["default"].createElement(_react.Fragment, null, tools) : null), _react["default"].createElement(Content, {
    absolute: absolute,
    tabIndex: 0
  }, list.map(function (_ref12) {
    var id = _ref12.id,
        active = _ref12.active,
        render = _ref12.render;
    return render({
      key: id,
      active: active
    });
  }))) : _ref13;
});
exports.Tabs = Tabs;
Tabs.displayName = 'Tabs';
Tabs.defaultProps = {
  id: null,
  children: null,
  tools: null,
  selected: null,
  absolute: false,
  bordered: false
};

var TabsState =
/*#__PURE__*/
function (_Component) {
  _inherits(TabsState, _Component);

  function TabsState(props) {
    var _this;

    _classCallCheck(this, TabsState);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(TabsState).call(this, props));
    _this.state = {
      selected: props.initial
    };
    return _this;
  }

  _createClass(TabsState, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          _this$props$bordered = _this$props.bordered,
          bordered = _this$props$bordered === void 0 ? false : _this$props$bordered,
          _this$props$absolute = _this$props.absolute,
          absolute = _this$props$absolute === void 0 ? false : _this$props$absolute,
          children = _this$props.children,
          backgroundColor = _this$props.backgroundColor;
      var selected = this.state.selected;
      return _react["default"].createElement(Tabs, {
        bordered: bordered,
        absolute: absolute,
        selected: selected,
        backgroundColor: backgroundColor,
        actions: {
          onSelect: function onSelect(id) {
            return _this2.setState({
              selected: id
            });
          }
        }
      }, children);
    }
  }]);

  return TabsState;
}(_react.Component);

exports.TabsState = TabsState;
TabsState.displayName = "TabsState";
TabsState.defaultProps = {
  children: [],
  initial: null,
  absolute: false,
  bordered: false,
  backgroundColor: ''
};