"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

require("core-js/modules/es.symbol");

require("core-js/modules/es.symbol.description");

require("core-js/modules/es.symbol.iterator");

require("core-js/modules/es.array.for-each");

require("core-js/modules/es.array.from");

require("core-js/modules/es.array.index-of");

require("core-js/modules/es.array.is-array");

require("core-js/modules/es.array.iterator");

require("core-js/modules/es.array.slice");

require("core-js/modules/es.date.to-string");

require("core-js/modules/es.object.assign");

require("core-js/modules/es.object.define-properties");

require("core-js/modules/es.object.freeze");

require("core-js/modules/es.object.keys");

require("core-js/modules/es.object.to-string");

require("core-js/modules/es.regexp.to-string");

require("core-js/modules/es.string.iterator");

require("core-js/modules/web.dom-collections.for-each");

require("core-js/modules/web.dom-collections.iterator");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WithTooltip = exports.WithToolTipState = exports.WithTooltipPure = void 0;

var _react = _interopRequireWildcard(require("react"));

var _theming = require("@storybook/theming");

var _clientLogger = require("@storybook/client-logger");

var _global = require("global");

var _reactPopperTooltip = _interopRequireDefault(require("react-popper-tooltip"));

var _Tooltip = require("./Tooltip");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _templateObject2() {
  var data = _taggedTemplateLiteral(["\n  cursor: ", ";\n"]);

  _templateObject2 = function _templateObject2() {
    return data;
  };

  return data;
}

function _templateObject() {
  var data = _taggedTemplateLiteral(["\n  display: inline-block;\n  cursor: ", ";\n"]);

  _templateObject = function _templateObject() {
    return data;
  };

  return data;
}

function _taggedTemplateLiteral(strings, raw) { if (!raw) { raw = strings.slice(0); } return Object.freeze(Object.defineProperties(strings, { raw: { value: Object.freeze(raw) } })); }

// A target that doesn't speak popper
var TargetContainer = _theming.styled.div(_templateObject(), function (props) {
  return props.mode === 'hover' ? 'default' : 'pointer';
});

var TargetSvgContainer = _theming.styled.g(_templateObject2(), function (props) {
  return props.mode === 'hover' ? 'default' : 'pointer';
});

// Pure, does not bind to the body
var WithTooltipPure = function WithTooltipPure(_ref) {
  var svg = _ref.svg,
      trigger = _ref.trigger,
      closeOnClick = _ref.closeOnClick,
      placement = _ref.placement,
      modifiers = _ref.modifiers,
      hasChrome = _ref.hasChrome,
      _tooltip = _ref.tooltip,
      children = _ref.children,
      tooltipShown = _ref.tooltipShown,
      onVisibilityChange = _ref.onVisibilityChange,
      props = _objectWithoutProperties(_ref, ["svg", "trigger", "closeOnClick", "placement", "modifiers", "hasChrome", "tooltip", "children", "tooltipShown", "onVisibilityChange"]);

  var Container = svg ? TargetSvgContainer : TargetContainer;
  return _react["default"].createElement(_reactPopperTooltip["default"], {
    placement: placement,
    trigger: trigger,
    modifiers: modifiers,
    tooltipShown: tooltipShown,
    onVisibilityChange: onVisibilityChange,
    tooltip: function tooltip(_ref2) {
      var getTooltipProps = _ref2.getTooltipProps,
          getArrowProps = _ref2.getArrowProps,
          tooltipRef = _ref2.tooltipRef,
          arrowRef = _ref2.arrowRef,
          tooltipPlacement = _ref2.placement;
      return _react["default"].createElement(_Tooltip.Tooltip, _extends({
        hasChrome: hasChrome,
        placement: tooltipPlacement,
        tooltipRef: tooltipRef,
        arrowRef: arrowRef,
        arrowProps: getArrowProps()
      }, getTooltipProps()), typeof _tooltip === 'function' ? _tooltip({
        onHide: function onHide() {
          return onVisibilityChange(false);
        }
      }) : _tooltip);
    }
  }, function (_ref3) {
    var getTriggerProps = _ref3.getTriggerProps,
        triggerRef = _ref3.triggerRef;
    return (// @ts-ignore
      _react["default"].createElement(Container, _extends({
        ref: triggerRef
      }, getTriggerProps(), props), children)
    );
  });
};

exports.WithTooltipPure = WithTooltipPure;
WithTooltipPure.displayName = "WithTooltipPure";
WithTooltipPure.defaultProps = {
  svg: false,
  trigger: 'hover',
  closeOnClick: false,
  placement: 'top',
  modifiers: {},
  hasChrome: true,
  tooltipShown: false
};

var WithToolTipState = function WithToolTipState(_ref4) {
  var startOpen = _ref4.startOpen,
      rest = _objectWithoutProperties(_ref4, ["startOpen"]);

  var _useState = (0, _react.useState)(startOpen || false),
      _useState2 = _slicedToArray(_useState, 2),
      tooltipShown = _useState2[0],
      onVisibilityChange = _useState2[1];

  (0, _react.useEffect)(function () {
    var hide = function hide() {
      return onVisibilityChange(false);
    };

    _global.document.addEventListener('keydown', hide, false); // Find all iframes on the screen and bind to clicks inside them (waiting until the iframe is ready)


    var iframes = Array.from(_global.document.getElementsByTagName('iframe'));
    var unbinders = [];
    iframes.forEach(function (iframe) {
      var bind = function bind() {
        try {
          if (iframe.contentWindow.document) {
            iframe.contentWindow.document.addEventListener('click', hide);
            unbinders.push(function () {
              try {
                iframe.contentWindow.document.removeEventListener('click', hide);
              } catch (e) {
                _clientLogger.logger.warn('Removing a click listener from iframe failed: ', e);
              }
            });
          }
        } catch (e) {
          _clientLogger.logger.warn('Adding a click listener to iframe failed: ', e);
        }
      };

      bind(); // I don't know how to find out if it's already loaded so I potentially will bind twice

      iframe.addEventListener('load', bind);
      unbinders.push(function () {
        iframe.removeEventListener('load', bind);
      });
    });
    return function () {
      _global.document.removeEventListener('keydown', hide);

      unbinders.forEach(function (unbind) {
        unbind();
      });
    };
  });
  return _react["default"].createElement(WithTooltipPure, _extends({}, rest, {
    tooltipShown: tooltipShown,
    onVisibilityChange: onVisibilityChange
  }));
};

exports.WithTooltip = exports.WithToolTipState = WithToolTipState;
WithToolTipState.displayName = "WithToolTipState";