import { SourceLocation as Loc, Position as Pos } from "./types";
import { Lines } from "./lines";
export default class Mapping {
    sourceLines: Lines;
    sourceLoc: Loc;
    targetLoc: Loc;
    constructor(sourceLines: Lines, sourceLoc: Loc, targetLoc?: Loc);
    slice(lines: Lines, start: Pos, end?: Pos): Mapping | null;
    add(line: number, column: number): Mapping;
    subtract(line: number, column: number): Mapping;
    indent(by: number, skipFirstLine?: boolean, noNegativeColumns?: boolean): Mapping;
}
