"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var recast_1 = __importDefault(require("recast"));
var babel_parser_1 = __importDefault(require("./babel-parser"));
var Documentation_1 = __importDefault(require("./Documentation"));
var cacher_1 = __importDefault(require("./utils/cacher"));
var resolveExportedComponent_1 = __importDefault(require("./utils/resolveExportedComponent"));
var documentRequiredComponents_1 = __importDefault(require("./utils/documentRequiredComponents"));
var ERROR_MISSING_DEFINITION = 'No suitable component definition found';
function parseScript(source, preHandlers, handlers, options, documentation, forceSingleExport) {
    if (forceSingleExport === void 0) { forceSingleExport = false; }
    return __awaiter(this, void 0, void 0, function () {
        var plugins, ast, _a, componentDefinitions, ievSet, docs;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    plugins = options.lang === 'ts' ? ['typescript'] : ['flow'];
                    if (options.jsx) {
                        plugins.push('jsx');
                    }
                    ast = cacher_1.default(function () { return recast_1.default.parse(source, { parser: babel_parser_1.default({ plugins: plugins }) }); }, source);
                    if (!ast) {
                        throw new Error("Unable to parse empty file \"" + options.filePath + "\"");
                    }
                    _a = resolveExportedComponent_1.default(ast), componentDefinitions = _a[0], ievSet = _a[1];
                    if (!(componentDefinitions.size === 0)) return [3 /*break*/, 2];
                    return [4 /*yield*/, documentRequiredComponents_1.default(documentation, ievSet, undefined, options)
                        // if we do not find any compoents throw
                    ];
                case 1:
                    docs = _b.sent();
                    // if we do not find any compoents throw
                    if (!docs.length) {
                        throw new Error(ERROR_MISSING_DEFINITION + " on \"" + options.filePath + "\"");
                    }
                    else {
                        return [2 /*return*/, docs];
                    }
                    _b.label = 2;
                case 2: return [2 /*return*/, executeHandlers(preHandlers, handlers, componentDefinitions, documentation, ast, options, forceSingleExport)];
            }
        });
    });
}
exports.default = parseScript;
function executeHandlers(preHandlers, localHandlers, componentDefinitions, documentation, ast, opt, forceSingleExport) {
    return __awaiter(this, void 0, void 0, function () {
        var compDefs, docs;
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    compDefs = componentDefinitions
                        .keys()
                        .filter(function (name) { return name && (!opt.nameFilter || opt.nameFilter.indexOf(name) > -1); });
                    if (forceSingleExport && compDefs.length > 1) {
                        throw 'vue-docgen-api: multiple exports in a component file are not handled by docgen.parse, Please use "docgen.parseMulti" instead';
                    }
                    return [4 /*yield*/, Promise.all(compDefs.map(function (name) { return __awaiter(_this, void 0, void 0, function () {
                            var doc, compDef;
                            var _this = this;
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0:
                                        doc = (compDefs.length > 1 && name !== 'default' ? undefined : documentation) ||
                                            new Documentation_1.default(opt.filePath);
                                        compDef = componentDefinitions.get(name);
                                        // execute all prehandlers in order
                                        return [4 /*yield*/, preHandlers.reduce(function (_, handler) { return __awaiter(_this, void 0, void 0, function () {
                                                return __generator(this, function (_a) {
                                                    switch (_a.label) {
                                                        case 0: return [4 /*yield*/, _];
                                                        case 1:
                                                            _a.sent();
                                                            return [4 /*yield*/, handler(doc, compDef, ast, opt)];
                                                        case 2: return [2 /*return*/, _a.sent()];
                                                    }
                                                });
                                            }); }, Promise.resolve())];
                                    case 1:
                                        // execute all prehandlers in order
                                        _a.sent();
                                        return [4 /*yield*/, Promise.all(localHandlers.map(function (handler) { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                                                switch (_a.label) {
                                                    case 0: return [4 /*yield*/, handler(doc, compDef, ast, opt)];
                                                    case 1: return [2 /*return*/, _a.sent()];
                                                }
                                            }); }); }))
                                            // end with setting of exportname
                                            // to avoid dependencies names bleeding on the main components,
                                            // do this step at the end of the function
                                        ];
                                    case 2:
                                        _a.sent();
                                        // end with setting of exportname
                                        // to avoid dependencies names bleeding on the main components,
                                        // do this step at the end of the function
                                        doc.set('exportName', name);
                                        return [2 /*return*/, doc];
                                }
                            });
                        }); }))
                        // default component first so in multiple exports in parse it is returned
                    ];
                case 1:
                    docs = _a.sent();
                    // default component first so in multiple exports in parse it is returned
                    return [2 /*return*/, docs.sort(function (a, b) { return (a.get('exportName') === 'default' ? -1 : b.get('exportName') === 'default' ? 1 : 0); })];
            }
        });
    });
}
