"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var bt = __importStar(require("@babel/types"));
var getDocblock_1 = __importDefault(require("../utils/getDocblock"));
var getDoclets_1 = __importDefault(require("../utils/getDoclets"));
var getTypeFromAnnotation_1 = __importDefault(require("../utils/getTypeFromAnnotation"));
var transformTagsIntoObject_1 = __importDefault(require("../utils/transformTagsIntoObject"));
var propHandler_1 = __importStar(require("./propHandler"));
var getArgFromDecorator_1 = __importDefault(require("../utils/getArgFromDecorator"));
/**
 * Extracts prop information from a class-style VueJs component
 * @param documentation
 * @param path
 */
function classPropHandler(documentation, path) {
    return __awaiter(this, void 0, void 0, function () {
        var config;
        return __generator(this, function (_a) {
            if (bt.isClassDeclaration(path.node)) {
                config = getArgFromDecorator_1.default(path.get('decorators'));
                if (config && bt.isObjectExpression(config.node)) {
                    propHandler_1.default(documentation, config);
                }
                path
                    .get('body')
                    .get('body')
                    .filter(function (p) { return bt.isClassProperty(p.node) && !!p.node.decorators; })
                    .forEach(function (propPath) {
                    var propDeco = (propPath.get('decorators') || []).filter(function (p) {
                        var exp = bt.isCallExpression(p.node.expression)
                            ? p.node.expression.callee
                            : p.node.expression;
                        return bt.isIdentifier(exp) && exp.name === 'Prop';
                    });
                    if (!propDeco.length) {
                        return;
                    }
                    var propName = bt.isIdentifier(propPath.node.key) ? propPath.node.key.name : undefined;
                    if (!propName) {
                        return;
                    }
                    var propDescriptor = documentation.getPropDescriptor(propName);
                    // description
                    var docBlock = getDocblock_1.default(propPath);
                    var jsDoc = docBlock ? getDoclets_1.default(docBlock) : { description: '', tags: [] };
                    var jsDocTags = jsDoc.tags ? jsDoc.tags : [];
                    if (jsDocTags) {
                        propDescriptor.tags = transformTagsIntoObject_1.default(jsDocTags);
                    }
                    if (jsDoc.description) {
                        propDescriptor.description = jsDoc.description;
                    }
                    propHandler_1.extractValuesFromTags(propDescriptor);
                    if (propPath.node.typeAnnotation) {
                        propDescriptor.type = getTypeFromAnnotation_1.default(propPath.node.typeAnnotation);
                    }
                    var propDecoratorPath = propDeco[0].get('expression');
                    if (bt.isCallExpression(propDecoratorPath.node)) {
                        var propDecoratorArg = propDecoratorPath.get('arguments', 0);
                        if (propDecoratorArg && bt.isObjectExpression(propDecoratorArg.node)) {
                            var propsPath = propDecoratorArg
                                .get('properties')
                                .filter(function (p) { return bt.isObjectProperty(p.node); });
                            // if there is no type annotation, get it from the decorators arguments
                            if (!propPath.node.typeAnnotation) {
                                propHandler_1.describeType(propsPath, propDescriptor);
                            }
                            propHandler_1.describeDefault(propsPath, propDescriptor);
                            propHandler_1.describeRequired(propsPath, propDescriptor);
                        }
                    }
                });
            }
            return [2 /*return*/];
        });
    });
}
exports.default = classPropHandler;
