"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var bt = __importStar(require("@babel/types"));
/**
 * Extracts component name from an object-style VueJs component
 * @param documentation
 * @param path
 */
function displayNameHandler(documentation, compDef) {
    return __awaiter(this, void 0, void 0, function () {
        var namePath, nameValuePath, singleNameValuePath, displayName, nameConstId, program;
        return __generator(this, function (_a) {
            if (bt.isObjectExpression(compDef.node)) {
                namePath = compDef
                    .get('properties')
                    .filter(function (p) { return bt.isObjectProperty(p.node) && p.node.key.name === 'name'; });
                // if no prop return
                if (!namePath.length) {
                    return [2 /*return*/];
                }
                nameValuePath = namePath[0].get('value');
                singleNameValuePath = !Array.isArray(nameValuePath) ? nameValuePath : null;
                displayName = null;
                if (singleNameValuePath) {
                    if (bt.isStringLiteral(singleNameValuePath.node)) {
                        displayName = singleNameValuePath.node.value;
                    }
                    else if (bt.isIdentifier(singleNameValuePath.node)) {
                        nameConstId = singleNameValuePath.node.name;
                        program = compDef.parentPath.parentPath;
                        if (program.name === 'body') {
                            displayName = getDeclaredConstantValue(program, nameConstId);
                        }
                    }
                }
                documentation.set('displayName', displayName);
            }
            return [2 /*return*/];
        });
    });
}
exports.default = displayNameHandler;
function getDeclaredConstantValue(prog, nameConstId) {
    var body = prog.node.body;
    var globalVariableDeclarations = body.filter(function (node) {
        return bt.isVariableDeclaration(node);
    });
    var declarators = globalVariableDeclarations.reduce(function (a, declPath) { return a.concat(declPath.declarations); }, []);
    var nodeDeclaratorArray = declarators.filter(function (d) { return bt.isIdentifier(d.id) && d.id.name === nameConstId; });
    var nodeDeclarator = nodeDeclaratorArray.length ? nodeDeclaratorArray[0] : undefined;
    return nodeDeclarator && nodeDeclarator.init && bt.isStringLiteral(nodeDeclarator.init)
        ? nodeDeclarator.init.value
        : null;
}
