"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var bt = __importStar(require("@babel/types"));
var recast_1 = __importDefault(require("recast"));
var getDocblock_1 = __importDefault(require("../utils/getDocblock"));
var getDoclets_1 = __importDefault(require("../utils/getDoclets"));
var transformTagsIntoObject_1 = __importDefault(require("../utils/transformTagsIntoObject"));
var getPropsFilter_1 = __importDefault(require("../utils/getPropsFilter"));
/**
 * Extract props information form an object-style VueJs component
 * @param documentation
 * @param path
 */
function propHandler(documentation, path) {
    return __awaiter(this, void 0, void 0, function () {
        var propsPath, modelPropertyName_1, propsValuePath, objProp, objPropFiltered;
        return __generator(this, function (_a) {
            if (bt.isObjectExpression(path.node)) {
                propsPath = path
                    .get('properties')
                    .filter(function (p) { return bt.isObjectProperty(p.node) && getPropsFilter_1.default('props')(p); });
                // if no prop return
                if (!propsPath.length) {
                    return [2 /*return*/];
                }
                modelPropertyName_1 = getModelPropName(path);
                propsValuePath = propsPath[0].get('value');
                if (bt.isObjectExpression(propsValuePath.node)) {
                    objProp = propsValuePath.get('properties');
                    objPropFiltered = objProp.filter(function (p) { return bt.isProperty(p.node); });
                    objPropFiltered.forEach(function (prop) {
                        var propNode = prop.node;
                        // description
                        var docBlock = getDocblock_1.default(prop);
                        var jsDoc = docBlock ? getDoclets_1.default(docBlock) : { description: '', tags: [] };
                        var jsDocTags = jsDoc.tags ? jsDoc.tags : [];
                        // if it's the v-model describe it only as such
                        var propertyName = propNode.key.name || propNode.key.value;
                        var isPropertyModel = jsDocTags.some(function (t) { return t.title === 'model'; }) || propertyName === modelPropertyName_1;
                        var propName = isPropertyModel ? 'v-model' : propertyName;
                        var propDescriptor = documentation.getPropDescriptor(propName);
                        var propValuePath = prop.get('value');
                        if (jsDoc.description) {
                            propDescriptor.description = jsDoc.description;
                        }
                        if (jsDocTags.length) {
                            propDescriptor.tags = transformTagsIntoObject_1.default(jsDocTags);
                        }
                        extractValuesFromTags(propDescriptor);
                        if (bt.isArrayExpression(propValuePath.node) || bt.isIdentifier(propValuePath.node)) {
                            // if it's an immediately typed property, resolve its type immediately
                            propDescriptor.type = getTypeFromTypePath(propValuePath);
                        }
                        else if (bt.isObjectExpression(propValuePath.node)) {
                            // standard default + type + required
                            var propPropertiesPath = propValuePath
                                .get('properties')
                                .filter(function (p) { return bt.isObjectProperty(p.node) || bt.isObjectMethod(p.node); });
                            // type
                            describeType(propPropertiesPath, propDescriptor);
                            // required
                            describeRequired(propPropertiesPath, propDescriptor);
                            // default
                            describeDefault(propPropertiesPath, propDescriptor);
                        }
                        else if (bt.isTSAsExpression(propValuePath.node)) {
                            // standard default + type + required with TS as annotation
                            var propPropertiesPath = propValuePath
                                .get('expression')
                                .get('properties')
                                .filter(function (p) { return bt.isObjectProperty(p.node); });
                            // type
                            propDescriptor.type = getTypeFromTypePath(propValuePath);
                            // required
                            describeRequired(propPropertiesPath, propDescriptor);
                            // default
                            describeDefault(propPropertiesPath, propDescriptor);
                        }
                        else {
                            // in any other case, just display the code for the typing
                            propDescriptor.type = {
                                name: recast_1.default.print(prop.get('value')).code,
                                func: true
                            };
                        }
                    });
                }
                else if (bt.isArrayExpression(propsValuePath.node)) {
                    propsValuePath
                        .get('elements')
                        .filter(function (e) { return bt.isStringLiteral(e.node); })
                        .forEach(function (e) {
                        var propDescriptor = documentation.getPropDescriptor(e.node.value);
                        propDescriptor.type = { name: 'undefined' };
                    });
                }
            }
            return [2 /*return*/];
        });
    });
}
exports.default = propHandler;
function describeType(propPropertiesPath, propDescriptor) {
    var typeArray = propPropertiesPath.filter(getPropsFilter_1.default('type'));
    if (typeArray.length) {
        propDescriptor.type = getTypeFromTypePath(typeArray[0].get('value'));
    }
    else {
        // deduce the type from default expression
        var defaultArray = propPropertiesPath.filter(getPropsFilter_1.default('default'));
        if (defaultArray.length) {
            var typeNode = defaultArray[0].node;
            if (bt.isObjectProperty(typeNode)) {
                var func = bt.isArrowFunctionExpression(typeNode.value) || bt.isFunctionExpression(typeNode.value);
                var typeValueNode = defaultArray[0].get('value').node;
                var typeName = typeof typeValueNode.value;
                propDescriptor.type = { name: func ? 'func' : typeName };
            }
        }
    }
}
exports.describeType = describeType;
var VALID_VUE_TYPES = [
    'string',
    'number',
    'boolean',
    'array',
    'object',
    'date',
    'function',
    'symbol'
];
function getTypeFromTypePath(typePath) {
    var typeNode = typePath.node;
    var typeName = bt.isTSAsExpression(typeNode) &&
        bt.isTSTypeReference(typeNode.typeAnnotation) &&
        typeNode.typeAnnotation.typeParameters
        ? recast_1.default.print(typeNode.typeAnnotation.typeParameters.params[0]).code
        : bt.isArrayExpression(typeNode)
            ? typePath
                .get('elements')
                .map(function (t) { return getTypeFromTypePath(t).name; })
                .join('|')
            : typeNode &&
                bt.isIdentifier(typeNode) &&
                VALID_VUE_TYPES.indexOf(typeNode.name.toLowerCase()) > -1
                ? typeNode.name.toLowerCase()
                : recast_1.default.print(typeNode).code;
    return {
        name: typeName === 'function' ? 'func' : typeName
    };
}
function describeRequired(propPropertiesPath, propDescriptor) {
    var requiredArray = propPropertiesPath.filter(getPropsFilter_1.default('required'));
    var requiredNode = requiredArray.length ? requiredArray[0].get('value').node : undefined;
    var required = requiredNode && bt.isBooleanLiteral(requiredNode) ? requiredNode.value : undefined;
    if (required !== undefined) {
        propDescriptor.required = required;
    }
}
exports.describeRequired = describeRequired;
function describeDefault(propPropertiesPath, propDescriptor) {
    var defaultArray = propPropertiesPath.filter(getPropsFilter_1.default('default'));
    if (defaultArray.length) {
        if (bt.isObjectProperty(defaultArray[0].value)) {
            var defaultPath = defaultArray[0].get('value');
            var parenthesized = false;
            if (bt.isArrowFunctionExpression(defaultPath.node) &&
                bt.isObjectExpression(defaultPath.node.body) // if () => ({})
            ) {
                defaultPath = defaultPath.get('body');
                var extra = defaultPath.node.extra;
                if (extra && extra.parenthesized) {
                    parenthesized = true;
                }
            }
            var rawValue = recast_1.default.print(defaultPath).code;
            propDescriptor.defaultValue = {
                func: bt.isFunction(defaultPath.node),
                value: parenthesized ? rawValue.slice(1, rawValue.length - 1) : rawValue
            };
        }
        else {
            var defaultPath = defaultArray[0].get('body');
            var rawValue = recast_1.default.print(defaultPath).code;
            propDescriptor.defaultValue = {
                func: bt.isFunction(defaultPath.node),
                value: "function()" + rawValue.trim()
            };
        }
    }
}
exports.describeDefault = describeDefault;
function extractValuesFromTags(propDescriptor) {
    if (propDescriptor.tags && propDescriptor.tags['values']) {
        var description = propDescriptor.tags['values'][0].description;
        var choices = typeof description === 'string' ? description.split(',') : undefined;
        if (choices) {
            propDescriptor.values = choices.map(function (v) { return v.trim(); });
        }
        delete propDescriptor.tags['values'];
    }
}
exports.extractValuesFromTags = extractValuesFromTags;
/**
 * extract the property model.prop from the component object
 * @param path component NodePath
 * @returns name of the model prop, null if none
 */
function getModelPropName(path) {
    var modelPath = path
        .get('properties')
        .filter(function (p) { return bt.isObjectProperty(p.node) && getPropsFilter_1.default('model')(p); });
    if (!modelPath.length) {
        return null;
    }
    var modelPropertyNamePath = modelPath.length &&
        modelPath[0]
            .get('value')
            .get('properties')
            .filter(function (p) { return bt.isObjectProperty(p.node) && getPropsFilter_1.default('prop')(p); });
    if (!modelPropertyNamePath.length) {
        return null;
    }
    var valuePath = modelPropertyNamePath[0].get('value');
    return bt.isStringLiteral(valuePath.node) ? valuePath.node.value : null;
}
