"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var bt = __importStar(require("@babel/types"));
var recast_1 = __importDefault(require("recast"));
var getDoclets_1 = __importDefault(require("../utils/getDoclets"));
var getDocblock_1 = require("../utils/getDocblock");
var transformTagsIntoObject_1 = __importDefault(require("../utils/transformTagsIntoObject"));
/**
 * Extract slots information form the render function of an object-style VueJs component
 * @param documentation
 * @param path
 */
function slotHandler(documentation, path) {
    return __awaiter(this, void 0, void 0, function () {
        var renderPath, renderValuePath;
        return __generator(this, function (_a) {
            if (bt.isObjectExpression(path.node)) {
                renderPath = path
                    .get('properties')
                    .filter(function (p) {
                    return (bt.isObjectProperty(p.node) || bt.isObjectMethod(p.node)) && p.node.key.name === 'render';
                });
                // if no prop return
                if (!renderPath.length) {
                    return [2 /*return*/];
                }
                renderValuePath = bt.isObjectProperty(renderPath[0].node)
                    ? renderPath[0].get('value')
                    : renderPath[0];
                recast_1.default.visit(renderValuePath.node, {
                    // this.$slots.default()
                    visitCallExpression: function (pathCall) {
                        if (bt.isMemberExpression(pathCall.node.callee) &&
                            bt.isMemberExpression(pathCall.node.callee.object) &&
                            bt.isThisExpression(pathCall.node.callee.object.object) &&
                            bt.isIdentifier(pathCall.node.callee.property) &&
                            (pathCall.node.callee.object.property.name === '$slots' ||
                                pathCall.node.callee.object.property.name === '$scopedSlots')) {
                            var doc = documentation.getSlotDescriptor(pathCall.node.callee.property.name);
                            var comment = getSlotComment(pathCall, doc);
                            var bindings = pathCall.node.arguments[0];
                            if (bt.isObjectExpression(bindings) && bindings.properties.length) {
                                doc.bindings = getBindings(bindings, comment ? comment.bindings : undefined);
                            }
                            return false;
                        }
                        this.traverse(pathCall);
                    },
                    // this.$slots.mySlot
                    visitMemberExpression: function (pathMember) {
                        if (bt.isMemberExpression(pathMember.node.object) &&
                            bt.isThisExpression(pathMember.node.object.object) &&
                            bt.isIdentifier(pathMember.node.object.property) &&
                            (pathMember.node.object.property.name === '$slots' ||
                                pathMember.node.object.property.name === '$scopedSlots') &&
                            bt.isIdentifier(pathMember.node.property)) {
                            var doc = documentation.getSlotDescriptor(pathMember.node.property.name);
                            getSlotComment(pathMember, doc);
                            return false;
                        }
                        this.traverse(pathMember);
                    },
                    visitJSXElement: function (pathJSX) {
                        var tagName = pathJSX.node.openingElement.name;
                        var nodeJSX = pathJSX.node;
                        if (!bt.isJSXElement(nodeJSX)) {
                            this.traverse(pathJSX);
                            return;
                        }
                        if (bt.isJSXIdentifier(tagName) && tagName.name === 'slot') {
                            var doc = documentation.getSlotDescriptor(getName(nodeJSX));
                            var parentNode = pathJSX.parentPath.node;
                            var comment_1;
                            if (bt.isJSXElement(parentNode)) {
                                comment_1 = getJSXDescription(nodeJSX, parentNode.children, doc);
                            }
                            var bindings = nodeJSX.openingElement.attributes;
                            if (bindings && bindings.length) {
                                doc.bindings = bindings.map(function (b) {
                                    return getBindingsFromJSX(b, comment_1 ? comment_1.bindings : undefined);
                                });
                            }
                            return false;
                        }
                        this.traverse(pathJSX);
                    }
                });
            }
            return [2 /*return*/];
        });
    });
}
exports.default = slotHandler;
function isStatement(path) {
    return (path &&
        (bt.isDeclaration(path.node) || bt.isReturnStatement(path.node) || bt.isIfStatement(path.node)));
}
function getName(nodeJSX) {
    var oe = nodeJSX.openingElement;
    var names = oe.attributes.filter(function (a) { return bt.isJSXAttribute(a) && a.name.name === 'name'; });
    var nameNode = names.length ? names[0].value : null;
    return nameNode && bt.isStringLiteral(nameNode) ? nameNode.value : 'default';
}
function getJSXDescription(nodeJSX, siblings, descriptor) {
    if (!siblings) {
        return undefined;
    }
    var indexInParent = siblings.indexOf(nodeJSX);
    var commentExpression = null;
    for (var i = indexInParent - 1; i > -1; i--) {
        var currentNode = siblings[i];
        if (bt.isJSXExpressionContainer(currentNode)) {
            commentExpression = currentNode;
            break;
        }
    }
    if (!commentExpression || !commentExpression.expression.innerComments) {
        return undefined;
    }
    var cmts = commentExpression.expression.innerComments;
    var lastComment = cmts[cmts.length - 1];
    return parseCommentNode(lastComment, descriptor);
}
function getSlotComment(path, descriptor) {
    var desc = getExpressionDescription(path, descriptor);
    if (desc) {
        return desc;
    }
    // in case we don't find a description on the expression,
    // look for it on the containing statement
    // 1: find the statement
    var i = 10;
    while (i-- && path && !isStatement(path)) {
        path = path.parentPath;
    }
    // 2: extract the description if it exists
    return path ? getExpressionDescription(path, descriptor) : undefined;
}
function getExpressionDescription(path, descriptor) {
    var node = path.node;
    if (!node || !node.leadingComments || node.leadingComments.length === 0) {
        return undefined;
    }
    return parseCommentNode(node.leadingComments[node.leadingComments.length - 1], descriptor);
}
function parseCommentNode(node, descriptor) {
    if (node.type !== 'CommentBlock') {
        return undefined;
    }
    return parseSlotDocBlock(node.value, descriptor);
}
function parseSlotDocBlock(str, descriptor) {
    var docBlock = getDocblock_1.parseDocblock(str).trim();
    var jsDoc = getDoclets_1.default(docBlock);
    if (!jsDoc.tags) {
        return undefined;
    }
    var slotTags = jsDoc.tags.filter(function (t) { return t.title === 'slot'; });
    if (slotTags.length) {
        var tagContent = slotTags[0].content;
        var description = typeof tagContent === 'string' ? tagContent : undefined;
        if (description && (!descriptor.description || !descriptor.description.length)) {
            descriptor.description = description;
        }
        var tags = jsDoc.tags.filter(function (t) { return t.title !== 'slot' && t.title !== 'binding'; });
        if (tags.length) {
            descriptor.tags = transformTagsIntoObject_1.default(tags);
        }
        return {
            bindings: jsDoc.tags.filter(function (t) { return t.title === 'binding'; })
        };
    }
    return undefined;
}
exports.parseSlotDocBlock = parseSlotDocBlock;
function getBindings(node, bindings) {
    return node.properties.map(function (prop) {
        var name = prop.key.name;
        var description = prop.leadingComments && prop.leadingComments.length
            ? getDocblock_1.parseDocblock(prop.leadingComments[prop.leadingComments.length - 1].value)
            : undefined;
        if (!description) {
            var descbinding = bindings ? bindings.filter(function (b) { return b.name === name; })[0] : undefined;
            if (descbinding) {
                return descbinding;
            }
        }
        return {
            title: 'binding',
            name: name,
            description: description
        };
    });
}
function getBindingsFromJSX(attr, bindings) {
    var name = attr.name.name;
    var descbinding = bindings ? bindings.filter(function (b) { return b.name === name; })[0] : undefined;
    if (descbinding) {
        return descbinding;
    }
    return {
        title: 'binding',
        name: name
    };
}
