"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var cleanName_1 = __importDefault(require("./cleanName"));
function getDefaultText() {
    return 'Default Example Usage';
}
function getDefaultNumber() {
    return '42';
}
function getDefaultBoolean() {
    return 'true';
}
function getDefaultArray() {
    return '[1, 2, 3]';
}
function getDefaultFunction() {
    return '() => void';
}
function getDefaultDate() {
    return 'new Date(\'2012-12-12\')';
}
function getDefaultObject() {
    return '{}';
}
function getDefault(prop) {
    if (!prop || !prop.type) {
        return getDefaultText();
    }
    else if (prop.values && prop.values.length) {
        return prop.values[0];
    }
    else if (prop.type.name === 'string') {
        return getDefaultText();
    }
    else if (prop.type.name === 'number') {
        return getDefaultNumber();
    }
    else if (prop.type.name === 'boolean') {
        return getDefaultBoolean();
    }
    else if (prop.type.name === 'object') {
        return getDefaultObject();
    }
    else if (prop.type.name === 'array') {
        return getDefaultArray();
    }
    else if (prop.type.name === 'func') {
        return getDefaultFunction();
    }
    else if (prop.type.name === 'date') {
        return getDefaultDate();
    }
    return getDefaultText();
}
exports.default = (function (doc) {
    var displayName = doc.displayName, props = doc.props, slots = doc.slots;
    var cleanedName = cleanName_1.default(displayName);
    var propsAttr = props
        ? props
            .filter(function (p) { return p.required; })
            .map(function (p) {
            return " " + (!p || !p.type || p.type.name === 'string' ? '' : ':') + p.name + "=\"" + getDefault(p) + "\"";
        })
        : [];
    return "<" + cleanedName + propsAttr.join(' ') + (!slots || !slots.filter(function (s) { return s.name === 'default'; })
        ? ' />'
        : ">" + getDefaultText() + "</" + cleanedName + ">");
});
