"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var path = __importStar(require("path"));
function resolveAliases(filePath, aliases) {
    var aliasKeys = Object.keys(aliases);
    var i = aliasKeys.length;
    var aliasFound = false;
    if (!aliasKeys.length) {
        return filePath;
    }
    while (!aliasFound && i--) {
        var aliasValueWithSlash = aliasKeys[i] + '/';
        aliasFound = filePath.substring(0, aliasValueWithSlash.length) === aliasValueWithSlash;
    }
    if (!aliasFound) {
        return filePath;
    }
    return path.join(aliases[aliasKeys[i]], filePath.substring(aliasKeys[i].length + 1));
}
exports.default = resolveAliases;
