"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var bt = __importStar(require("@babel/types"));
var ts_map_1 = __importDefault(require("ts-map"));
function resolveExportDeclaration(path) {
    var definitions = new ts_map_1.default();
    if (bt.isExportDefaultDeclaration(path.node)) {
        var defaultPath = path;
        definitions.set('default', defaultPath.get('declaration'));
    }
    else if (bt.isExportNamedDeclaration(path.node)) {
        var declaration = path.get('declaration');
        // export const example = {}
        if (declaration && bt.isVariableDeclaration(declaration.node)) {
            declaration.get('declarations').each(function (declarator) {
                var nodeId = declarator.node.id;
                if (bt.isIdentifier(nodeId)) {
                    definitions.set(nodeId.name, declarator);
                }
            });
        }
        else {
            // const example = {}
            // export { example }
            getDefinitionsFromPathSpecifiers(path, definitions);
        }
    }
    else if (bt.isExportDeclaration(path.node)) {
        getDefinitionsFromPathSpecifiers(path, definitions);
    }
    return definitions;
}
exports.default = resolveExportDeclaration;
function getDefinitionsFromPathSpecifiers(path, defs) {
    var specifiersPath = path.get('specifiers');
    specifiersPath.each(function (specifier) {
        defs.set(specifier.node.exported.name, bt.isExportSpecifier(specifier.node) ? specifier.get('local') : specifier.get('exported'));
    });
}
