"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var bt = __importStar(require("@babel/types"));
var recast_1 = __importDefault(require("recast"));
function ignore() {
    return false;
}
function resolveIdentifier(ast, path) {
    if (!bt.isIdentifier(path.node)) {
        return path;
    }
    var varName = path.node.name;
    var comp = null;
    recast_1.default.visit(ast.program, {
        // to look only at the root we ignore all traversing
        visitFunctionDeclaration: ignore,
        visitFunctionExpression: ignore,
        visitClassExpression: ignore,
        visitIfStatement: ignore,
        visitWithStatement: ignore,
        visitSwitchStatement: ignore,
        visitWhileStatement: ignore,
        visitDoWhileStatement: ignore,
        visitForStatement: ignore,
        visitForInStatement: ignore,
        visitVariableDeclaration: function (variablePath) {
            if (!bt.isVariableDeclaration(variablePath.node)) {
                return false;
            }
            var varID = variablePath.node.declarations[0].id;
            if (!varID || !bt.isIdentifier(varID) || varID.name !== varName) {
                return false;
            }
            comp = variablePath.get('declarations', 0).get('init');
            return false;
        },
        visitClassDeclaration: function (classPath) {
            var classID = classPath.node.id;
            if (!classID || !bt.isIdentifier(classID) || classID.name !== varName) {
                return false;
            }
            comp = classPath;
            return false;
        }
    });
    return comp;
}
exports.default = resolveIdentifier;
