"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var bt = __importStar(require("@babel/types"));
var recast_1 = __importDefault(require("recast"));
function default_1(ast, variableFilter) {
    var variables = {};
    var importedVariablePaths = {};
    var exportAllFiles = [];
    // get imported variable names and filepath
    recast_1.default.visit(ast.program, {
        visitImportDeclaration: function (astPath) {
            if (!astPath.node.source) {
                return false;
            }
            var filePath = astPath.node.source.value;
            if (typeof filePath !== 'string') {
                return false;
            }
            var specifiers = astPath.get('specifiers');
            specifiers.each(function (s) {
                var varName = s.node.local.name;
                var exportName = bt.isImportSpecifier(s.node) ? s.node.imported.name : 'default';
                importedVariablePaths[varName] = { filePath: [filePath], exportName: exportName };
            });
            return false;
        }
    });
    recast_1.default.visit(ast.program, {
        visitExportNamedDeclaration: function (astPath) {
            var specifiers = astPath.get('specifiers');
            if (astPath.node.source) {
                var filePath_1 = astPath.node.source.value;
                if (typeof filePath_1 !== 'string') {
                    return false;
                }
                specifiers.each(function (s) {
                    var varName = s.node.exported.name;
                    var exportName = s.node.local ? s.node.local.name : varName;
                    if (variableFilter.indexOf(varName) > -1) {
                        variables[varName] = { filePath: [filePath_1], exportName: exportName };
                    }
                });
            }
            else {
                specifiers.each(function (s) {
                    var varName = s.node.exported.name;
                    var middleName = s.node.local.name;
                    var importedVar = importedVariablePaths[middleName];
                    if (importedVar && variableFilter.indexOf(varName) > -1) {
                        variables[varName] = importedVar;
                    }
                });
            }
            return false;
        },
        visitExportDefaultDeclaration: function (astPath) {
            if (variableFilter.indexOf('default') > -1) {
                var middleNameDeclaration = astPath.node.declaration;
                if (bt.isIdentifier(middleNameDeclaration)) {
                    var middleName = middleNameDeclaration.name;
                    var importedVar = importedVariablePaths[middleName];
                    if (importedVar) {
                        variables.default = importedVar;
                    }
                }
            }
            return false;
        },
        visitExportAllDeclaration: function (astPath) {
            var newFilePath = astPath.get('source').node.value;
            exportAllFiles.push(newFilePath);
            return false;
        }
    });
    if (exportAllFiles.length) {
        variableFilter.filter(function (v) { return !variables[v]; }).forEach(function (exportName) {
            variables[exportName] = { filePath: exportAllFiles, exportName: exportName };
        });
    }
    return variables;
}
exports.default = default_1;
