/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */
/**
 * Utility class for local storage operations.
 */
export declare class LocalStorageUtils {
    /**
     * Private constructor to avoid object instantiation from outside
     * the class.
     *
     * @hideconstructor
     */
    private constructor();
    /**
     * Set a value in local storage.
     *
     * @param {string} key - Key to set the value under.
     * @param {string} value - Value to be set.
     */
    static setValueInLocalStorage(key: string, value: string): void;
    /**
     * Get a value from local storage.
     *
     * @param {string} key - Key to retrieve the value.
     * @returns {string} Value or null.
     */
    static getValueFromLocalStorage(key: string): string;
}
/**
 * Utility class for session storage operations.
 */
export declare class SessionStorageUtils {
    /**
     * Private constructor to avoid object instantiation from outside
     * the class.
     *
     * @hideconstructor
     */
    private constructor();
    /**
     * Clear the session storage completely.
     */
    static clearSessionStorage(): void;
    /**
     * Clear a specific item from the session storage.
     *
     * @param {string} key - Key of the item to be removed.
     */
    static clearItemFromSessionStorage(key: string): void;
    /**
     * Set a specific item to the session storage.
     *
     * @param {string} key - Key of the item to be set.
     * @param {string} value - Value of the item to be set.
     */
    static setItemToSessionStorage(key: string, value: string): void;
    /**
     * Get a specific item from the session storage.
     *
     * @param {string} key - Key of the item to be retrieved.
     */
    static getItemFromSessionStorage(key: string): string;
}
