/**
 * Copyright (c) 2021, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { TestableComponentInterface } from "@wso2is/core/models";
import { ReactElement } from "react";
import { FieldProps } from "react-final-form";
import { FormFieldMessage } from "../models";
export interface FormFieldPropsInterface extends FieldProps<any, any, any>, TestableComponentInterface {
    /**
     * Aria label for the field.
     */
    ariaLabel: string;
    /**
     * Type of the form field.
     */
    fieldType: "default" | "identifier" | "name" | "resourceName" | "email" | "url" | "copy-input" | "password" | "phoneNumber" | "primary-btn" | "cancel-btn" | "danger-btn" | "secondary-btn" | "link-btn";
    /**
     * Hint of the form field.
     */
    hint?: string;
    /**
     * Max length of the input.
     */
    maxLength?: number;
    /**
     * Regex pattern to validate the input against.
     */
    pattern?: string;
    /**
     * Message to be displayed.
     */
    message?: FormFieldMessage;
    /**
     * Validation of the field.
     */
    validation?: any;
}
/**
 * Implementation of the Form Field component.
 * @param props
 */
export declare const Field: {
    (props: FormFieldPropsInterface): ReactElement;
    /**
     * Default props for the component.
     */
    defaultProps: {
        fieldType: string;
        maxLength: number;
        width: number;
    };
};
