/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { Hooks } from "./constants";
import { HttpClientInstance } from "./http-client";
import { ConfigInterface, CustomGrantRequestParams, DecodedIdTokenPayloadInterface, HttpRequestConfig, HttpResponse, ServiceResourcesType, UserInfo, WebWorkerConfigInterface } from "./models";
/**
 * IdentityClient class constructor.
 *
 * @export
 * @class IdentityClient
 * @implements {ConfigInterface} - Configuration interface.
 */
export declare class IdentityClient {
    private _authConfig;
    private static _instance;
    private _client;
    private _storage;
    private _initialized;
    private _startedInitialize;
    private _onSignInCallback;
    private _onSignOutCallback;
    private _onEndUserSession;
    private _onInitialize;
    private _onCustomGrant;
    private _onHttpRequestStart;
    private _onHttpRequestSuccess;
    private _onHttpRequestFinish;
    private _onHttpRequestError;
    private _httpClient;
    private constructor();
    static getInstance(): IdentityClient;
    /**
     * This method initializes the `IdentityClient` instance.
     *
     * @preserve
     *
     * @param {ConfigInterface | WebWorkerConfigInterface} config The config object to initialize with.
     *
     * @return {Promise<boolean>} Resolves to true if initialization is successful.
     */
    initialize(config: ConfigInterface | WebWorkerConfigInterface): Promise<boolean>;
    getUserInfo(): Promise<UserInfo>;
    validateAuthentication(): null;
    /**
     * Sign-in method.
     *
     * @param {() => void} [callback] - Callback method to run on successful sign-in
     * @returns {Promise<any>} promise.
     * @memberof IdentityClient
     */
    signIn(fidp?: string): Promise<any>;
    /**
     * Sign-out method.
     *
     * @param {() => void} [callback] - Callback method to run on successful sign-in
     * @returns {Promise<any>} promise.
     * @memberof IdentityClient
     */
    signOut(): Promise<any>;
    httpRequest(config: HttpRequestConfig): Promise<HttpResponse>;
    httpRequestAll(config: HttpRequestConfig[]): Promise<HttpResponse[]>;
    customGrant(requestParams: CustomGrantRequestParams): Promise<any>;
    endUserSession(): Promise<any>;
    getServiceEndpoints(): Promise<ServiceResourcesType>;
    getHttpClient(): HttpClientInstance;
    getDecodedIDToken(): Promise<DecodedIdTokenPayloadInterface>;
    getAccessToken(): Promise<string>;
    refreshToken(): Promise<string>;
    on(hook: Hooks.CustomGrant, callback: (response?: any) => void, id: string): void;
    on(hook: Hooks.EndUserSession | Hooks.HttpRequestError | Hooks.HttpRequestFinish | Hooks.HttpRequestStart | Hooks.HttpRequestSuccess | Hooks.Initialize | Hooks.SignIn | Hooks.SignOut, callback: (response?: any) => void): void;
}
//# sourceMappingURL=client.d.ts.map