/**
 * Copyright (c) 2019, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { ConfigInterface, OpenIDConfig, ServiceResourcesType, WebWorkerConfigInterface } from "../models";
/**
 * Checks whether openid configuration initiated.
 *
 * @returns {boolean}
 */
export declare const isOPConfigInitiated: (requestParams: ConfigInterface | WebWorkerConfigInterface) => boolean;
/**
 * Set OAuth2 authorize endpoint.
 *
 * @param {string} authorizationEndpoint
 */
export declare const setAuthorizeEndpoint: (authorizationEndpoint: string, requestParams: ConfigInterface | WebWorkerConfigInterface) => void;
/**
 * Sets the open id config data on the session.
 *
 * @param {OpenIDConfig} data - The Open ID Config.
 * @param {ConfigInterface} requestParams - Initial Config.
 */
export declare const setOPConfig: (data: OpenIDConfig, requestParams: ConfigInterface | WebWorkerConfigInterface) => void;
/**
 * Returns the Open ID config from the session.
 *
 * @param {ConfigInterface} requestParams - Initial Config.
 *
 * @return {OpenIDConfig} - Open ID Config.
 */
export declare const getOPConfig: (requestParams: ConfigInterface | WebWorkerConfigInterface) => OpenIDConfig;
/**
 * Set OAuth2 token endpoint.
 *
 * @param {string} tokenEndpoint
 */
export declare const setTokenEndpoint: (tokenEndpoint: string, requestParams: ConfigInterface | WebWorkerConfigInterface) => void;
/**
 * Set OIDC end session endpoint.
 *
 * @param {string} endSessionEndpoint
 */
export declare const setEndSessionEndpoint: (endSessionEndpoint: string, requestParams: ConfigInterface | WebWorkerConfigInterface) => void;
/**
 * Set JWKS URI.
 *
 * @param jwksEndpoint
 */
export declare const setJwksUri: (jwksEndpoint: string, requestParams: ConfigInterface | WebWorkerConfigInterface) => void;
/**
 * Set OAuth2 revoke token endpoint.
 *
 * @param {string} revokeTokenEndpoint
 */
export declare const setRevokeTokenEndpoint: (revokeTokenEndpoint: string, requestParams: ConfigInterface | WebWorkerConfigInterface) => void;
/**
 * Set openid configuration initiated.
 */
export declare const setOPConfigInitiated: (requestParams: ConfigInterface | WebWorkerConfigInterface) => void;
/**
 * Set sign-in redirect URL.
 */
export declare const setSignInRedirectURL: (url: string, requestParams: ConfigInterface | WebWorkerConfigInterface) => void;
/**
 * Set sign-out redirect URL.
 */
export declare const setSignOutRedirectURL: (url: string, requestParams: ConfigInterface | WebWorkerConfigInterface) => void;
/**
 * Set OIDC Session IFrame URL.
 */
export declare const setOIDCSessionIFrameURL: (url: string, requestParams: ConfigInterface | WebWorkerConfigInterface) => void;
/**
 * Set id_token issuer.
 *
 * @param issuer id_token issuer.
 */
export declare const setIssuer: (issuer: string, requestParams: ConfigInterface | WebWorkerConfigInterface) => void;
/**
 * Set Client ID.
 *
 * @param {string} clientID - Client ID of the application.
 */
export declare const setClientID: (requestParams: ConfigInterface | WebWorkerConfigInterface) => void;
/**
 * Initialize openid provider configuration.
 *
 * @param {string} wellKnownEndpoint openid provider configuration.
 * @param {boolean} forceInit whether to initialize the configuration again.
 * @returns {Promise<any>} promise.
 */
export declare const initOPConfiguration: (requestParams: ConfigInterface | WebWorkerConfigInterface, forceInit: boolean) => Promise<any>;
/**
 * Reset openid provider configuration.
 */
export declare const resetOPConfiguration: (requestParams: ConfigInterface | WebWorkerConfigInterface) => void;
export declare const getServiceEndpoints: (authConfig: ConfigInterface | WebWorkerConfigInterface) => ServiceResourcesType;
/**
 * Get OAuth2 authorize endpoint.
 *
 * @returns {string|null}
 */
export declare const getAuthorizeEndpoint: (requestParams: ConfigInterface | WebWorkerConfigInterface) => string | null;
/**
 * Get OAuth2 token endpoint.
 *
 * @returns {string|null}
 */
export declare const getTokenEndpoint: (requestParams: ConfigInterface | WebWorkerConfigInterface) => string | null;
/**
 * Get OAuth2 revoke token endpoint.
 *
 * @returns {string|null}
 */
export declare const getRevokeTokenEndpoint: (requestParams: ConfigInterface | WebWorkerConfigInterface) => string | null;
export declare const getOIDCSessionIFrameURL: (requestParams: ConfigInterface | WebWorkerConfigInterface) => string | null;
/**
 * Get OIDC end session endpoint.
 *
 * @returns {string|null}
 */
export declare const getEndSessionEndpoint: (requestParams: ConfigInterface | WebWorkerConfigInterface) => string | null;
/**
 * Get JWKS URI.
 *
 * @returns {string|null}
 */
export declare const getJwksUri: (requestParams: ConfigInterface | WebWorkerConfigInterface) => string | null;
/**
 * Get authenticated user's username
 *
 * @returns {string|null}
 */
export declare const getUsername: (requestParams: ConfigInterface | WebWorkerConfigInterface) => string | null;
/**
 * Get tenant name
 *
 * @returns {any}
 */
export declare const getTenant: (requestParams: ConfigInterface | WebWorkerConfigInterface) => string | null;
/**
 * Get id_token issuer.
 *
 * @returns {any}
 */
export declare const getIssuer: (requestParams: ConfigInterface | WebWorkerConfigInterface) => string;
/**
 * Get Client ID.
 *
 * @return {string}
 */
export declare const getClientID: (requestParams: ConfigInterface | WebWorkerConfigInterface) => string;
/**
 * Checks whether openid configuration initiated is valid.
 *
 * @param {string} tenant - Tenant of the logged in user.
 * @param {string} clientID - Client ID of the application.
 * @return {boolean}
 */
export declare const isValidOPConfig: (requestParams: ConfigInterface | WebWorkerConfigInterface) => boolean;
//# sourceMappingURL=op-config.d.ts.map