# Contributing to WSO2 Identity Server Apps

We would really appreciate your contributions to WSO2 Identity Server Apps to help make it even better than it is today!
As a contributor, here are the guidelines we would like you to follow:

 - [Developer Guide](./docs/DEVELOPER.md)
 - [Style Guide](./docs/STYLE-GUIDE.md)

## Developer Guide

In order to maintain a consistent and quality code-base, please keep the following in mind when you 
submit your contributions.

* Set up the [necessary tools](./docs/DEVELOPER.md#setting-up-development-tools) which ensures code quality and consistency.
* Adhere to the code style and [formatting guideline](./docs/DEVELOPER.md#formatting).
* Write well structured and documented code.
* Fulfil the action items listed in the pull request template.
* Sign the CLA.

## Style Guide

We introduced this guide in order to maintain the consistency of all the portals from the code base 
to the visual representation. please bear the following guidelines in mind when you make a contribution 
to the repo.

- Source files fundamentals
- Basic file structure
- Code formatting
- [Form validations](./docs/STYLE-GUIDE.md#Form-Library)
- Accessibility support
- Using custom components
- Performance
- [UI design guidelines](https://github.com/wso2-enterprise/asgardeo-app-extensions/blob/master/docs/ui-design-guide.md)
