# WSO2 Identity Apps Style Guide

The WSO2 Identity Apps Style Guide introduces a set of conventions to be followed when a developer contributes to WSO2 
Identity App portals. It is much easier to understand a complex product, or a codebase when a set of guidelines are in 
place ensuring consistency. Therefore, through this style guide a set of guidelines, that comprises file naming 
conventions, code formatting styles, UI design guidelines, etc., are provided.

## Table of Content

- [Introduction](#Introduction)
- Source files fundamentals
- Basic file structure
- Code formatting
- [Form library](#Form-Library)
- Accessibility support
- Using custom components
- Performance
- [Developer guidelines](https://github.com/wso2/identity-apps/blob/master/docs/DEVELOPER.md)
- [UI design guidelines](https://github.com/wso2-enterprise/asgardeo-app-extensions/blob/master/docs/ui-design-guide.md)


## Introduction

This document serves as the complete definition of WSO2’s coding standards for source code and UI design conventions 
for the portals that are implemented. The main objective of introducing this is to maintain the consistency of products 
from the code base to the visual representation. 

However, this document focuses primarily on the hard-and-fast rules that we follow universally, and avoids giving 
advice that isn't clearly enforceable. Especially when it comes to the code formatting, file naming conventions, and 
accessibility support criteria. The UI design guidelines will be helpful for the developers who will introduce new 
UI components or enhance the existing UI elements in the products. The guide discusses various UI/UX aspects including 
the element styles (colors, paddings, borders, etc.), element placements, usage of the custom UI components, etc.

## Form Library

The @wso2is/form library that we use in the WSO2 Identity App portals cater to all the requirements that are 
identified when it comes to its use-cases. This helps to govern the styles of the form elements, and the behavioral 
patterns of the forms used in WSO2 Identity Apps. Follow [these guidelines](https://github.com/wso2/identity-apps/blob/master/docs/FORMS.md) 
to implement a form in the Identity App portals more efficiently, maintaining consistency of the UI aspects as well as the 
code base that are introduced in the Asgardeo forms.
