/**
 * Copyright (c) 2021, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * This class will contain front end permissions which is required to
 * be passed on to the permission context and also while checking the
 * relvant permission is available when the show component is evaluvating.
 */
export declare class AccessControlConstants {
    /**
     * Private constructor to avoid object instantiation from outside
     * the class.
     *
     * @hideconstructor
     */
    private constructor();
    /**
     * Application Feature permisison
     */
    static readonly APPLICATION: string;
    /**
     * Application read permission
     */
    static readonly APPLICATION_READ: string;
    /**
     * Application write permission
     */
    static readonly APPLICATION_WRITE: string;
    /**
     * Application edit permission
     */
    static readonly APPLICATION_EDIT: string;
    /**
     * Application delete permission
     */
    static readonly APPLICATION_DELETE: string;
    /**
     * Identity provider feature permission
     */
    static readonly IDP: string;
    /**
     * Identity provider read permission
     */
    static readonly IDP_READ: string;
    /**
     * Identity provider write permission
     */
    static readonly IDP_WRITE: string;
    /**
     * Identity provider edit permission
     */
    static readonly IDP_EDIT: string;
    /**
     * Identity provider delete permission
     */
    static readonly IDP_DELETE: string;
    /**
     * Users feature permission
     */
    static readonly USER: string;
    /**
     * Users read permission
     */
    static readonly USER_READ: string;
    /**
     * Users write permission
     */
    static readonly USER_WRITE: string;
    /**
     * Users edit permission
     */
    static readonly USER_EDIT: string;
    /**
     * Users delete permission
     */
    static readonly USER_DELETE: string;
    /**
     * Group feature permission
     */
    static readonly GROUP: string;
    /**
     * Group read permission
     */
    static readonly GROUP_READ: string;
    /**
     * Group write permission
     */
    static readonly GROUP_WRITE: string;
    /**
     * Group edit permission
     */
    static readonly GROUP_EDIT: string;
    /**
     * Group delete permission
     */
    static readonly GROUP_DELETE: string;
    /**
     * Role feature permission
     */
    static readonly ROLE: string;
    /**
     * Role read permission
     */
    static readonly ROLE_READ: string;
    /**
     * Role write permission
     */
    static readonly ROLE_WRITE: string;
    /**
     * Role edit permission
     */
    static readonly ROLE_EDIT: string;
    /**
     * Role delete permission
     */
    static readonly ROLE_DELETE: string;
    /**
     * Attribute feature permission
     */
    static readonly ATTRIBUTE: string;
    /**
     * Attribute read permission
     */
    static readonly ATTRIBUTE_READ: string;
    /**
     * Attribute write permission
     */
    static readonly ATTRIBUTE_WRITE: string;
    /**
     * Attribute edit permission
     */
    static readonly ATTRIBUTE_EDIT: string;
    /**
     * Attribute delete permission
     */
    static readonly ATTRIBUTE_DELETE: string;
    /**
     * Scope feature permission
     */
    static readonly SCOPE: string;
    /**
     * Scope read permission
     */
    static readonly SCOPE_READ: string;
    /**
     * Scope write permission
     */
    static readonly SCOPE_WRITE: string;
    /**
     * Scope edit permission
     */
    static readonly SCOPE_EDIT: string;
    /**
     * Scope delete permission
     */
    static readonly SCOPE_DELETE: string;
    /**
     * Full console scope
     */
    static readonly FULL_UI_SCOPE: string;
}
