/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Class containing profile operation constants.
 */
export declare class ProfileConstants {
    /**
     * Private constructor to avoid object instantiation from outside
     * the class.
     *
     * @hideconstructor
     */
    private constructor();
    static readonly SCIM2_CORE_USER_SCHEMA: string;
    static readonly SCIM2_ENT_USER_SCHEMA: string;
    static readonly SCIM2_WSO2_USER_SCHEMA: string;
    static readonly SCIM2_WSO2_CUSTOM_SCHEMA: string;
    static readonly SCHEMA_FETCH_REQUEST_INVALID_RESPONSE_CODE_ERROR: string;
    static readonly SCHEMA_FETCH_REQUEST_ERROR: string;
    static readonly PROFILE_INFO_FETCH_REQUEST_INVALID_RESPONSE_CODE_ERROR: string;
    static readonly PROFILE_INFO_FETCH_REQUEST_ERROR: string;
    static readonly PROFILE_INFO_UPDATE_REQUEST_INVALID_RESPONSE_CODE_ERROR: string;
    static readonly PROFILE_INFO_UPDATE_REQUEST_ERROR: string;
    static readonly ACCOUNT_SWITCH_REQUEST_ERROR: string;
    static readonly GRAVATAR_IMAGE_FETCH_REQUEST_ERROR: string;
    /**
     * Set of SCIM2 schema names.
     * @constant
     * @type {Map<string, string>}
     * @default
     */
    static readonly SCIM2_SCHEMA_DICTIONARY: Map<string, string>;
    /**
     * States if the SCIM schema is mutable.
     */
    static readonly READONLY_SCHEMA: string;
}
