/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { AuthReducerStateInterface, MultiValueAttributeInterface, ProfileInfoInterface } from "../models";
/**
 * Resolves the user's display name.
 *
 * @param {ProfileInfoInterface} profileInfo - profile information.
 * @param {AuthReducerStateInterface} authState - Contains basic profile info extracted from the ID token.
 * @param {string} fallback - Fallback value.
 * @return {string} - Resolved display name.
 */
export declare const resolveUserDisplayName: (profileInfo: ProfileInfoInterface, authState?: AuthReducerStateInterface, fallback?: string) => string;
/**
 * Same username can exist in two different user stores. This function
 * will resolve the username so that the `PRIMARY` user store users will
 * have just the username and the other user store users will have their
 * corresponding user store prefixed to their username.
 *
 * @param {string} username - Username of the user.
 * @param {string} userStoreDomain - User store domain of the user.
 * @return {string}
 */
export declare const resolveUsername: (username: string, userStoreDomain: string) => string;
/**
 * Resolves the user's username when the user store is embedded
 * in it. `PRIMARY` user store users will have just the username
 * and the other user store users will have their corresponding
 * user store prefixed to their username.
 *
 * @param {string} username - Username of the user with user store embedded.
 * @return {string}
 */
export declare const resolveUserStoreEmbeddedUsername: (username: string) => string;
/**
 * Get the user's emails as a string array.
 *
 * @param {(string | MultiValueAttributeInterface)[]} emails - User emails.
 * @return {string[]} Emails as a string array.
 */
export declare const resolveUserEmails: (emails: (string | MultiValueAttributeInterface)[]) => string[];
/**
 * This function returns the username without the user store domain prefix.
 *
 * @param {string} userNameWithDomain - Username of the user with the userStore domain.
 * @return {string} User name without domain.
 */
export declare const getUserNameWithoutDomain: (userNameWithDomain: string) => string;
/**
 * Get the user's userstore as a string.
 *
 * @param {string} username - Username.
 * @return {string} Userstore as a string.
 */
export declare const resolveUserstore: (username: string) => string;
