/**
 * Copyright (c) 2021, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { Button, CopyInputField, DangerButton, LinkButton, Password, PrimaryButton } from "@wso2is/react-components";
import omit from "lodash-es/omit";
import React from "react";
import { Checkbox, Form, Input, Select } from "semantic-ui-react";
import { FieldButtonTypes } from "../models";
/**
 * The enter key.
 * @constant
 * @type {string}
 */
const ENTER_KEY = "Enter";
export const TextFieldAdapter = (props) => {
    const { childFieldProps, input, meta, parentFormProps } = props;
    return (React.createElement(Form.Input, Object.assign({ "aria-label": childFieldProps.ariaLabel, key: childFieldProps.testId, required: childFieldProps.required, "data-testid": childFieldProps.testId, label: childFieldProps.label !== "" ? childFieldProps.label : null, onKeyPress: (event, data) => {
            event.key === ENTER_KEY && input.onBlur(data === null || data === void 0 ? void 0 : data.name);
        }, onChange: (event, data) => {
            if (childFieldProps.listen && typeof childFieldProps.listen === "function") {
                childFieldProps.listen(data === null || data === void 0 ? void 0 : data.value);
            }
            input.onChange(data === null || data === void 0 ? void 0 : data.value);
        }, onBlur: (event) => input.onBlur(event), control: Input, autoFocus: childFieldProps.autoFocus || false, value: meta.modified ? input.value
            : ((childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.value) ? childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.value
                : ((parentFormProps === null || parentFormProps === void 0 ? void 0 : parentFormProps.values[childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.name]) ? parentFormProps === null || parentFormProps === void 0 ? void 0 : parentFormProps.values[childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.name] : "")) }, omit(childFieldProps, ["value", "listen"]), { type: childFieldProps.inputType === "number"
            ? "number"
            : "text", error: (meta.error && meta.touched)
            ? meta.error
            : null, onKeyDown: 
        // Restrict typing non-numeric characters in the "number" input fields.
        // Setting `type=number` is not sufficient to support firefox & IE.
        // Port fix from https://github.com/wso2/identity-apps/pull/2035
        childFieldProps.inputType === "number"
            ? ((event) => {
                const isNumber = /^[0-9]$/i.test(event.key);
                const isAllowed = ((event.key === "a"
                    || event.key === "v"
                    || event.key === "c"
                    || event.key === "x")
                    && (event.ctrlKey === true
                        || event.metaKey === true))
                    || (event.key === "ArrowRight"
                        || event.key == "ArrowLeft")
                    || (event.key === "Delete"
                        || event.key === "Backspace");
                !isNumber && !isAllowed && event.preventDefault();
            })
            : () => { return; }, onPaste: 
        // Restrict pasting non-numeric characters in the "number" input fields
        // Setting `type=number` is not sufficient to support firefox & IE.
        // Port fix from https://github.com/wso2/identity-apps/pull/2035
        childFieldProps.inputType === "number"
            ? ((event) => {
                const data = event.clipboardData.getData("Text");
                const isNumber = /^[0-9]+$/i.test(data);
                !isNumber && event.preventDefault();
            })
            : () => { return; } })));
};
export const PasswordFieldAdapter = (props) => {
    const { childFieldProps, input, meta, parentFormProps } = props;
    return (React.createElement(Password, Object.assign({ key: childFieldProps.testId, "data-testid": childFieldProps.testId, hidePassword: "Hide password", label: childFieldProps.label !== "" ? childFieldProps.label : null, name: "newPassword", required: true, showPassword: "Show password", onKeyPress: (event, data) => {
            event.key === ENTER_KEY && input.onBlur(data === null || data === void 0 ? void 0 : data.name);
        }, onChange: (event, data) => input.onChange(data === null || data === void 0 ? void 0 : data.value), onBlur: (event) => input.onBlur(event), error: (meta.error && meta.touched)
            ? meta.error
            : null, autoFocus: childFieldProps.autoFocus || false }, childFieldProps, { value: meta.modified ? input.value
            : ((childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.value) ? childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.value
                : ((parentFormProps === null || parentFormProps === void 0 ? void 0 : parentFormProps.values[childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.name]) ? parentFormProps === null || parentFormProps === void 0 ? void 0 : parentFormProps.values[childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.name] : "")) })));
};
export const CopyFieldAdapter = (props) => {
    const { childFieldProps, parentFormProps } = props;
    const { label } = childFieldProps, filteredChildFieldProps = __rest(childFieldProps, ["label"]);
    return (React.createElement(Form.Group, { grouped: true },
        label && (React.createElement("div", { className: `field ${filteredChildFieldProps.required ? "required" : ""}` },
            React.createElement("label", null, label))),
        React.createElement(Form.Field, null,
            React.createElement(CopyInputField, Object.assign({ key: filteredChildFieldProps.testId, "data-testid": filteredChildFieldProps.testId, autoFocus: filteredChildFieldProps.autoFocus || false }, filteredChildFieldProps, { value: (filteredChildFieldProps === null || filteredChildFieldProps === void 0 ? void 0 : filteredChildFieldProps.value)
                    ? filteredChildFieldProps === null || filteredChildFieldProps === void 0 ? void 0 : filteredChildFieldProps.value
                    : ((parentFormProps === null || parentFormProps === void 0 ? void 0 : parentFormProps.values[filteredChildFieldProps === null || filteredChildFieldProps === void 0 ? void 0 : filteredChildFieldProps.name])
                        ? parentFormProps === null || parentFormProps === void 0 ? void 0 : parentFormProps.values[filteredChildFieldProps === null || filteredChildFieldProps === void 0 ? void 0 : filteredChildFieldProps.name]
                        : "") })))));
};
export const TextAreaAdapter = (props) => {
    const { childFieldProps, input, meta, parentFormProps } = props;
    return (React.createElement(Form.TextArea, Object.assign({ label: childFieldProps.label !== "" ? childFieldProps.label : null, width: input.width, placeholder: input.placeholder, name: input.name, onBlur: (event) => input.onBlur(event), onChange: (event, data) => {
            if (childFieldProps.listen && typeof childFieldProps.listen === "function") {
                childFieldProps.listen(data === null || data === void 0 ? void 0 : data.value);
            }
            input.onChange(data === null || data === void 0 ? void 0 : data.value);
        }, autoFocus: childFieldProps.autoFocus || false, readOnly: input.readOnly, disabled: input.disabled, required: input.required, onKeyPress: (event, data) => {
            event.key === ENTER_KEY && input.onBlur(data.name);
        }, type: "textarea" }, omit(childFieldProps, ["value", "listen"]), { value: meta.modified ? input.value : ((childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.value) ? childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.value
            : ((parentFormProps === null || parentFormProps === void 0 ? void 0 : parentFormProps.values[childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.name]) ? parentFormProps === null || parentFormProps === void 0 ? void 0 : parentFormProps.values[childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.name] : "")), error: (meta.error && meta.touched)
            ? meta.error
            : null })));
};
/**
 * Toggle adapter.
 * @deprecated Use `CheckboxAdapter` instead.
 *
 * @param props - Props injected to the component. props - Props injected to the component.
 *
 * @return {React.ReactElement}
 */
export const ToggleAdapter = (props) => {
    const { childFieldProps, input, meta } = props;
    return (React.createElement(Form.Checkbox, Object.assign({ label: childFieldProps.label, name: childFieldProps.name, children: childFieldProps.children, onChange: (event, data) => {
            if (childFieldProps.listen && typeof childFieldProps.listen === "function") {
                childFieldProps.listen(data === null || data === void 0 ? void 0 : data.checked);
            }
            input.onChange(data === null || data === void 0 ? void 0 : data.checked);
        }, control: Checkbox, readOnly: childFieldProps.readOnly, disabled: childFieldProps.disabled, defaultChecked: !(childFieldProps.value.length == 0), autoFocus: childFieldProps.autoFocus || false }, childFieldProps)));
};
/**
 * Semantic Checkbox adapter.
 * @see {@link https://codesandbox.io/s/react-final-form-simple-example-3we74?fontsize=14&file=/index.js}
 *
 * @param {CheckboxAdapterPropsInterface} props - Props injected to the component.
 *
 * @return {React.ReactElement}
 */
export const CheckboxAdapter = (props) => {
    const { childFieldProps } = props, _a = props.input, { value } = _a, input = __rest(_a, ["value"]), rest = __rest(props, ["childFieldProps", "input"]);
    // unused, just don't pass it along with the ...rest
    const { 
    /* eslint-disable @typescript-eslint/no-unused-vars */
    type, meta, hint, children, parentFormProps, render, width } = rest, 
    /* eslint-enable @typescript-eslint/no-unused-vars */
    filteredRest = __rest(rest, ["type", "meta", "hint", "children", "parentFormProps", "render", "width"]);
    return (React.createElement(Form.Checkbox, Object.assign({}, input, filteredRest, { label: childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.label, name: childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.name, onChange: (event, { checked }) => {
            if ((childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.listen) && typeof childFieldProps.listen === "function") {
                childFieldProps.listen(checked);
            }
            input.onChange({
                target: {
                    checked,
                    type: "checkbox",
                    value
                }
            });
        } })));
};
export const SelectAdapter = (props) => {
    const { childFieldProps, input, meta } = props;
    return (React.createElement(Form.Select, Object.assign({ label: childFieldProps.label, name: childFieldProps.name, options: childFieldProps.children, onChange: (event, data) => {
            if (childFieldProps.listen && typeof childFieldProps.listen === "function") {
                childFieldProps.listen(data.value.toString());
            }
            input.onChange(data.value.toString());
        }, onBlur: (event) => input.onBlur(event), autoFocus: childFieldProps.autoFocus || false, disabled: childFieldProps.disabled, required: childFieldProps.required, onKeyPress: (event, data) => {
            event.key === ENTER_KEY && input.onBlur(data === null || data === void 0 ? void 0 : data.name);
        }, control: Select }, omit(childFieldProps, ["value", "children"]), { error: (meta.error && meta.touched)
            ? meta.error
            : null, value: meta.modified ? input.value : ((childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.value) ? childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.value : "") })));
};
export const ButtonAdapter = ({ childFieldProps }) => {
    if (childFieldProps.buttonType === FieldButtonTypes.BUTTON_PRIMARY) {
        return (React.createElement(PrimaryButton, Object.assign({}, omit(childFieldProps, ["label"]), { disabled: childFieldProps.disabled, key: childFieldProps.testId, type: "submit" }), childFieldProps.label));
    }
    else if (childFieldProps.buttonType === FieldButtonTypes.BUTTON_CANCEL) {
        return (React.createElement(LinkButton, Object.assign({}, omit(childFieldProps, ["label"]), { disabled: childFieldProps.disabled, key: childFieldProps.testId }), "Cancel"));
    }
    else if (childFieldProps.buttonType === FieldButtonTypes.BUTTON_LINK) {
        return (React.createElement(LinkButton, Object.assign({}, omit(childFieldProps, ["label"]), { disabled: childFieldProps.disabled, key: childFieldProps.testId }), childFieldProps.label));
    }
    else if (childFieldProps.buttonType === FieldButtonTypes.BUTTON_DANGER) {
        return (React.createElement(DangerButton, Object.assign({}, omit(childFieldProps, ["label"]), { disabled: childFieldProps.disabled, key: childFieldProps.testId }), childFieldProps.label));
    }
    else {
        return (React.createElement(Button, Object.assign({}, omit(childFieldProps, ["label"]), { disabled: childFieldProps.disabled, key: childFieldProps.testId }), childFieldProps.label));
    }
};
//# sourceMappingURL=adapters.js.map