/**
 * Copyright (c) 2021, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { Hint, MessageWithIcon } from "@wso2is/react-components";
import React from "react";
import { Field as FinalFormField } from "react-final-form";
import { CopyFieldAdapter, PasswordFieldAdapter, TextFieldAdapter } from "./adapters";
import { FieldInputTypes } from "../models";
import { getValidation } from "../utils";
/**
 * Implementation of the Input Field component.
 * @param props
 */
export const FieldInput = (props) => {
    const { inputType, hint, maxLength, message, validation, ["data-testid"]: testId } = props, rest = __rest(props, ["inputType", "hint", "maxLength", "message", "validation", "data-testid"]);
    const inputFieldGenerator = () => {
        if (inputType == FieldInputTypes.INPUT_PASSWORD) {
            return (React.createElement(FinalFormField, Object.assign({ key: testId, type: "password", name: props.name, parse: value => value, component: PasswordFieldAdapter, validate: (value, allValues, meta) => getValidation(value, meta, "password", props.required, inputType, validation) }, rest)));
        }
        else if (inputType == FieldInputTypes.INPUT_COPY) {
            return (React.createElement(FinalFormField, Object.assign({ key: testId, type: "text", name: props.name, parse: value => value, component: CopyFieldAdapter, validate: (value, allValues, meta) => getValidation(value, meta, "text", props.required, inputType, validation) }, rest)));
        }
        else if (inputType == FieldInputTypes.INPUT_NUMBER) {
            return (React.createElement(FinalFormField, Object.assign({ key: testId, type: "number", name: props.name, parse: value => value, component: TextFieldAdapter, validate: (value, allValues, meta) => getValidation(value, meta, "text", props.required, inputType, validation) }, rest)));
        }
        else {
            return (React.createElement(FinalFormField, Object.assign({ key: testId, type: "text", name: props.name, parse: value => value, component: TextFieldAdapter, validate: (value, allValues, meta) => getValidation(value, meta, "text", props.required, inputType, validation) }, props)));
        }
    };
    const resolveInputFieldMessage = () => {
        switch (props.message.type) {
            case "info":
                return (React.createElement(MessageWithIcon, { type: props.message.type, content: props.message.content, header: props.message.header }));
            case "warning":
                return (React.createElement(MessageWithIcon, { type: props.message.type, content: props.message.content, header: props.message.header }));
            case "error":
                return (React.createElement(MessageWithIcon, { type: props.message.type, content: props.message.content, header: props.message.header }));
        }
    };
    return (React.createElement(React.Fragment, null,
        inputFieldGenerator(),
        props.hint && (React.createElement(Hint, { compact: true }, props.hint)),
        props.message && (resolveInputFieldMessage())));
};
/**
 * Default props for the component.
 */
FieldInput.defaultProps = {
    inputType: "default",
    maxLength: 50,
    minLength: 3,
    type: FieldInputTypes.INPUT_DEFAULT,
    width: 16
};
//# sourceMappingURL=field-input.js.map