/**
 * Copyright (c) 2021, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React, { cloneElement, forwardRef, useImperativeHandle, useRef } from "react";
import { Form as FinalForm } from "react-final-form";
import { Grid, Form as SemanticForm } from "semantic-ui-react";
/**
 * Implementation of the Form component.
 * @param props
 */
export const Form = forwardRef((props, ref) => {
    let { noValidate, triggerSubmit } = props, other = __rest(props, ["noValidate", "triggerSubmit"]);
    const { children, onSubmit, uncontrolledForm } = other, rest = __rest(other, ["children", "onSubmit", "uncontrolledForm"]);
    const formRef = useRef(null);
    const childNodes = React.Children.toArray(children);
    const skipFinalTypes = (type) => {
        let skip;
        const typeToBeSkipped = ["FieldDropdown"];
        skip = typeToBeSkipped.some((skipType) => {
            return type === skipType;
        });
        return skip;
    };
    useImperativeHandle(ref, () => ({
        triggerSubmit: () => {
            var _a;
            /**
             * What is this?
             *
             * Below this line we have the logic to trigger the native
             * form's submit event. Currently we don't maintain UI for
             * submit button, neither previous buttons.
             *
             * The parent wizard is only responsible for changing it's wizard
             * pages based on the current index. To facilitate external
             * submit handling we expose a imperative handler that uses
             * a react ref to trigger the onSubmit manually. This is
             * because, inherently react-final-form uses its form submission
             * to properly keep track of the redux state.
             *
             * We should be able to synthetically tell react final form
             * that a page has been changed and please trigger {@link handleSubmit}
             * to make sure values are saved.
             *
             * {@see onSubmit}
             * {@link https://final-form.org/docs/react-final-form/faq}
             */
            if (formRef) {
                const submission = new Event('submit', {
                    cancelable: true,
                    bubbles: true
                });
                (_a = formRef.current) === null || _a === void 0 ? void 0 : _a.dispatchEvent(submission);
            }
        }
    }));
    const addPropsToChild = (childNodes, formRenderProps) => {
        return childNodes.map((child) => {
            var _a, _b, _c, _d;
            // Safety pre-conditions
            if (!child)
                return null;
            if (!child.type)
                return child;
            const { form, handleSubmit, pristine, submitting, values, initialValues } = formRenderProps;
            const parentFormProps = { form, handleSubmit, pristine, submitting, values, initialValues };
            const childFieldProps = child.props;
            const childProps = { childFieldProps, parentFormProps };
            const allProps = Object.assign(Object.assign({}, props), { childProps });
            // Check whether children of this element is valid
            // and is type array.
            const hasChildrenAndIsValid = Array.isArray((_a = child.props) === null || _a === void 0 ? void 0 : _a.children) &&
                ((_b = child.props) === null || _b === void 0 ? void 0 : _b.children.every(React.isValidElement)) &&
                child.props.children.length > 0;
            // If the react element has only 1 child, the react top level
            // API parses the children as a single object instead of type
            // array.
            const hasOnlyOneChild = (typeof ((_c = child.props) === null || _c === void 0 ? void 0 : _c.children) === "object");
            if (uncontrolledForm) {
                if ((hasChildrenAndIsValid || hasOnlyOneChild) && !skipFinalTypes(child.type.name)) {
                    return React.createElement(child.type, Object.assign(Object.assign({}, allProps), { children: addPropsToChild(React.Children.toArray((_d = child.props) === null || _d === void 0 ? void 0 : _d.children), formRenderProps) }));
                }
            }
            return cloneElement(child, childProps);
        });
    };
    const renderComponents = (childNodes, formRenderProps) => {
        let modifiedChildNodes = addPropsToChild(childNodes, formRenderProps);
        return modifiedChildNodes.map((child, index) => {
            var _a, _b, _c;
            if (!child) {
                return null;
            }
            if (child.props.childFieldProps && ((_b = (_a = child.props) === null || _a === void 0 ? void 0 : _a.childFieldProps) === null || _b === void 0 ? void 0 : _b.hidden)) {
                return null;
            }
            return (React.createElement(Grid.Row, { key: index },
                React.createElement(Grid.Column, { width: (_c = child.props.childFieldProps) === null || _c === void 0 ? void 0 : _c.width }, child)));
        });
    };
    return (React.createElement(FinalForm, Object.assign({ onSubmit: (values, form) => onSubmit(values, form), keepDirtyOnReinitialize: true, render: (formRenderProps) => {
            const { handleSubmit } = formRenderProps;
            if (triggerSubmit && typeof triggerSubmit === "function") {
                triggerSubmit(handleSubmit);
            }
            return (React.createElement("form", { noValidate: noValidate, onSubmit: handleSubmit, ref: formRef },
                React.createElement(SemanticForm, { noValidate: noValidate },
                    React.createElement(Grid, { className: "form-container with-max-width" }, renderComponents(childNodes, formRenderProps)))));
        } }, rest)));
});
/**
 * Default props for the component.
 */
Form.defaultProps = {
    noValidate: true,
};
//# sourceMappingURL=form.js.map