/**
 * Copyright (c) 2021, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { TestableComponentInterface } from "@wso2is/core/models";
import React, { ReactElement } from "react";
import { FieldProps } from "react-final-form";
export interface FormFieldPropsInterface extends FieldProps<any, any, any>, TestableComponentInterface {
    /**
     * Aria label for the field.
     */
    ariaLabel: string;
    /**
     * Additional classes.
     */
    className?: string;
    /**
     * Custom styles object
     */
    style?: object;
}
/**
 * Implementation of the Form Field component.
 * @param props
 */
export declare const Field: {
    (props: FormFieldPropsInterface): ReactElement;
    Input: {
        (props: import("./field-input").FieldInputPropsInterface): React.ReactElement<any, string | React.JSXElementConstructor<any>>;
        defaultProps: {
            inputType: string;
            maxLength: number;
            minLength: number;
            type: import("..").FieldInputTypes;
            width: number;
        };
    };
    Button: {
        (props: import("./field-button").FieldButtonPropsInterface): React.ReactElement<any, string | React.JSXElementConstructor<any>>;
        defaultProps: {
            type: import("..").FieldButtonTypes;
        };
    };
    Textarea: (props: import("./field-textarea").FieldTextareaPropsInterface) => React.ReactElement<any, string | React.JSXElementConstructor<any>>;
    CheckboxLegacy: (props: import("./field-checkbox-legacy").FieldCheckboxLegacyPropsInterface) => React.ReactElement<any, string | React.JSXElementConstructor<any>>;
    Checkbox: React.FunctionComponent<import("./field-checkbox").FieldCheckboxPropsInterface>;
    Dropdown: (props: import("./field-dropdown").FieldDropdownPropsInterface) => React.ReactElement<any, string | React.JSXElementConstructor<any>>;
};
