"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

exports.__esModule = true;
exports.RefFindNode = void 0;

var _inheritsLoose2 = _interopRequireDefault(require("@babel/runtime/helpers/inheritsLoose"));

var React = _interopRequireWildcard(require("react"));

var ReactDOM = _interopRequireWildcard(require("react-dom"));

var _utils = require("./utils");

/**
 * Detects if a passed element is a Fiber object instead of an element. Is needed as `ReactDOM.findDOMNode()` returns
 * a Fiber in `react-test-renderer` that can cause issues with tests. Is used only in non-production env.
 *
 * @see https://github.com/facebook/react/issues/7371#issuecomment-317396864
 * @see https://github.com/Semantic-Org/Semantic-UI-React/issues/4061#issuecomment-694895617
 */
function isFiberRef(node) {
  if (node === null) {
    return false;
  }

  if (node instanceof Element || node instanceof Text) {
    return false;
  }

  return !!(node.type && node.tag);
}

var RefFindNode = /*#__PURE__*/function (_React$Component) {
  (0, _inheritsLoose2.default)(RefFindNode, _React$Component);

  function RefFindNode() {
    var _this;

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _React$Component.call.apply(_React$Component, [this].concat(args)) || this;
    _this.prevNode = null;
    return _this;
  }

  var _proto = RefFindNode.prototype;

  _proto.componentDidMount = function componentDidMount() {
    var currentNode = ReactDOM.findDOMNode(this);

    if (process.env.NODE_ENV !== 'production') {
      if (isFiberRef(currentNode)) {
        currentNode = null;
      }
    }

    this.prevNode = currentNode;
    (0, _utils.handleRef)(this.props.innerRef, currentNode);
  };

  _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
    var currentNode = ReactDOM.findDOMNode(this);

    if (process.env.NODE_ENV !== 'production') {
      if (isFiberRef(currentNode)) {
        currentNode = null;
      }
    }

    if (this.prevNode !== currentNode) {
      this.prevNode = currentNode;
      (0, _utils.handleRef)(this.props.innerRef, currentNode);
    }

    if (prevProps.innerRef !== this.props.innerRef) {
      (0, _utils.handleRef)(this.props.innerRef, currentNode);
    }
  };

  _proto.componentWillUnmount = function componentWillUnmount() {
    (0, _utils.handleRef)(this.props.innerRef, null);
    delete this.prevNode;
  };

  _proto.render = function render() {
    var children = this.props.children;
    return children;
  };

  return RefFindNode;
}(React.Component);

exports.RefFindNode = RefFindNode;
//# sourceMappingURL=RefFindNode.js.map
