"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var React = require("react");
var utils_1 = require("./utils");
var RefForward = /** @class */ (function (_super) {
    tslib_1.__extends(RefForward, _super);
    function RefForward() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.currentNode = null;
        _this.handleRefOverride = function (node) {
            var _a = _this.props, children = _a.children, innerRef = _a.innerRef;
            utils_1.handleRef(children.ref, node);
            utils_1.handleRef(innerRef, node);
            _this.currentNode = node;
        };
        return _this;
    }
    RefForward.prototype.componentDidUpdate = function (prevProps) {
        if (prevProps.innerRef !== this.props.innerRef) {
            utils_1.handleRef(this.props.innerRef, this.currentNode);
        }
    };
    RefForward.prototype.componentWillUnmount = function () {
        delete this.currentNode;
    };
    RefForward.prototype.render = function () {
        var children = this.props.children;
        return React.cloneElement(children, {
            ref: this.handleRefOverride,
        });
    };
    return RefForward;
}(React.Component));
exports.RefForward = RefForward;
