"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var react_component_ref_1 = require("@fluentui/react-component-ref");
var enzyme_1 = require("enzyme");
var React = require("react");
var fixtures_1 = require("./fixtures");
describe('Ref', function () {
    describe('children', function () {
        it('renders single child', function () {
            var child = React.createElement("div", { "data-child": "whatever" });
            var innerRef = React.createRef();
            var component = enzyme_1.shallow(React.createElement(react_component_ref_1.Ref, { innerRef: innerRef }, child));
            expect(component.contains(child)).toBeTruthy();
        });
        it('renders RefFindNode when a component is passed', function () {
            var innerRef = React.createRef();
            var wrapper = enzyme_1.shallow(React.createElement(react_component_ref_1.Ref, { innerRef: innerRef },
                React.createElement(fixtures_1.CompositeClass, null)));
            expect(wrapper.is(react_component_ref_1.RefFindNode)).toBe(true);
        });
        it('renders RefForward when a component wrapper with forwardRef() is passed', function () {
            var innerRef = React.createRef();
            var wrapper = enzyme_1.shallow(React.createElement(react_component_ref_1.Ref, { innerRef: innerRef },
                React.createElement(fixtures_1.ForwardedRef, null)));
            expect(wrapper.is(react_component_ref_1.RefForward)).toBe(true);
        });
    });
});
