<!-- Logo -->
<p align="center">
  <a href="https://react.semantic-ui.com">
    <img height="128" width="128" src="https://github.com/Semantic-Org/Semantic-UI-React/raw/master/docs/public/logo.png">
  </a>
</p>

<!-- Name -->
<h1 align="center">
  <a href="https://react.semantic-ui.com/">Semantic UI React</a>
</h1>

<!-- Badges -->
<p align="center">
  <a href="https://gitter.im/Semantic-Org/Semantic-UI-React">
    <img alt="Gitter" src="https://img.shields.io/badge/gitter-join_chat-1dce73.svg?logo=data%3Aimage%2Fsvg%2Bxml%3Bbase64%2CPD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4NCjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48cmVjdCB4PSIwIiB5PSI1IiBmaWxsPSIjZmZmIiB3aWR0aD0iMSIgaGVpZ2h0PSI1Ii8%2BPHJlY3QgeD0iMiIgeT0iNiIgZmlsbD0iI2ZmZiIgd2lkdGg9IjEiIGhlaWdodD0iNyIvPjxyZWN0IHg9IjQiIHk9IjYiIGZpbGw9IiNmZmYiIHdpZHRoPSIxIiBoZWlnaHQ9IjciLz48cmVjdCB4PSI2IiB5PSI2IiBmaWxsPSIjZmZmIiB3aWR0aD0iMSIgaGVpZ2h0PSI0Ii8%2BPC9zdmc%2B&logoWidth=8&style=flat-square&maxAge=2592000" />
  </a>
  <a href="https://circleci.com/gh/Semantic-Org/Semantic-UI-React/tree/master">
    <img alt="Circle" src="https://img.shields.io/circleci/project/github/Semantic-Org/Semantic-UI-React/master.svg?style=flat-square" />
  </a>
  <a href="https://codecov.io/gh/Semantic-Org/Semantic-UI-React">
    <img alt="Codecov" src="https://img.shields.io/codecov/c/github/Semantic-Org/Semantic-UI-React/master.svg?style=flat-square" />
  </a>
  <a href="https://david-dm.org/Semantic-Org/Semantic-UI-React">
    <img alt="David" src="https://img.shields.io/david/Semantic-Org/Semantic-UI-React.svg?style=flat-square" />
  </a>
  <a href="https://www.npmjs.com/package/semantic-ui-react">
    <img alt="npm" src="https://img.shields.io/npm/v/semantic-ui-react.svg?style=flat-square" />
  </a>
</p>

## Installation & Usage

See the [**Documentation**][2] for an introduction, usage information, and examples.

## Built With

<p align="center">
  <img height="50" src="https://github.com/Semantic-Org/Semantic-UI-React/raw/master/docs/public/amazon-logo.png" />
  <img height="50" src="https://github.com/Semantic-Org/Semantic-UI-React/raw/master/docs/public/netflix-logo.png" />
  <img height="50" src="https://github.com/Semantic-Org/Semantic-UI-React/raw/master/docs/public/microsoft-logo.png" />
</p>

- Amazon Publishing — the full-service publisher of Amazon — [APub.com](https://amazonpublishing.amazon.com)
- Netflix's Edge Developer Experience team's numerous [internal apps](https://github.com/Semantic-Org/Semantic-UI-React/issues/1604)
- Netflix's [flamescope][31]
- Microsoft's [Teams](https://products.office.com/en-US/microsoft-teams/group-chat-software) prototyping

## Example Projects

This is a listing of example projects and guides that will help you integrate Semantic UI React into your new or existing projects.

<details>
  <summary>Show projects</summary>
 
  ### [semantic-ui-react-todos][100]
  Semantic UI React implementation of [react-redux Todo List][101].
</details>

## FAQ

<details>
  <summary><b>Can I use custom Icons?</b></summary>
  Yes.  Just use <code>&lt;Icon className='my-icon' /&gt;</code> instead of <code>&lt;Icon name='my-icon' /&gt;</code>.  See https://github.com/Semantic-Org/Semantic-UI-React/issues/931#issuecomment-263643210 for detailed info and examples.
</details>

<details>
  <summary><b>How do I setup CSS?</b></summary>

There are several options. Refer to our doc on [CSS Usage][23].

</details>

<details>
  <summary><b>Can I use a custom CSS theme?</b></summary>
  Yes.  Semantic UI React includes components that render valid Semantic UI HTML, no CSS is included.  This allows you to load any Semantic UI CSS theme on top of your Semantic UI React app.
</details>

<br />

Here are some helpful links:

- [Building CSS with Webpack][24]
- [Building CSS with Meteor][30]
- [Creating a standalone theme][25]

## How Can I Help?

### [Voice Your Opinion][19]

Help shape this library by weighing in on our [RFC (request for comments)][19] issues.

### [Contribute][1]

Our [CONTRIBUTING.md][1] is a step-by-step setup and development guide.

### [Good First Issue][21]

Issues labeled [`good first issue`][21] are a great way to ease into development on this project.

### [Missing Components][17]

We're seeking component parity with Semantic UI, plus some addons. There is an issue for every missing component, labeled [`new component`][17]. Just comment on the issue you'd like to take.

### [Help Wanted Label][4]

Any other issue labeled [`help wanted`][4] is ready for a PR.

## Principles

- No animation dependencies
- Simple declarative component APIs vs brittle HTML markup
- Complete keyboard support
- Complete SUI component definition support
- Completely documented
- Completely tested
- Accessible

## Credit

Created by [@levithomason][26] and an amazing community of [contributors][20].

Made possible only by [@jlukic][32] authoring [Semantic UI][5].

Blazing deployments by <a href="https://vercel.com/?utm_source=semantic-ui-react"><img height="12" width="14" src="https://github.com/Semantic-Org/Semantic-UI-React/raw/master/docs/public/vercel-logo.svg" /> Vercel</a>.

[1]: https://github.com/Semantic-Org/Semantic-UI-React/blob/master/.github/CONTRIBUTING.md
[2]: https://react.semantic-ui.com/
[3]: https://facebook.github.io/react/
[4]: https://github.com/Semantic-Org/Semantic-UI-React/labels/help%20wanted
[5]: https://semantic-ui.com/
[6]: https://github.com/Semantic-Org/Semantic-UI-React/milestone/1
[7]: https://github.com/webpack/webpack-dev-server/
[8]: https://github.com/Semantic-Org/Semantic-UI-React/issues/243
[9]: https://github.com/TechnologyAdvice
[10]: https://en.wikipedia.org/wiki/Eating_your_own_dog_food
[11]: https://github.com/Semantic-Org/Semantic-UI-React/issues/247
[12]: https://github.com/Semantic-Org/Semantic-UI-React/issues/243
[13]: https://webpack.github.io
[14]: https://github.com/Semantic-Org/Semantic-UI-React/issues
[15]: https://github.com/skywinder/github-changelog-generator
[17]: https://github.com/Semantic-Org/Semantic-UI-React/issues?q=is%3Aissue+is%3Aopen+label%3A%22new+component%22
[18]: https://github.com/Semantic-Org/Semantic-UI-React/blob/master/CHANGELOG.md
[19]: https://github.com/Semantic-Org/Semantic-UI-React/issues?q=is%3Aopen+RFC+label%3ARFC
[20]: https://github.com/Semantic-Org/Semantic-UI-React/graphs/contributors
[21]: https://github.com/Semantic-Org/Semantic-UI-React/labels/good%20first%20issue
[22]: https://github.com/Semantic-Org/Semantic-UI-React/edit/master/README.md
[23]: https://react.semantic-ui.com/usage#css
[24]: https://medium.com/webmonkeys/webpack-2-semantic-ui-theming-a216ddf60daf
[25]: http://learnsemantic.com/themes/creating.html
[26]: https://github.com/levithomason
[27]: https://github.com/layershifter
[30]: https://github.com/Semantic-Org/Semantic-UI-Meteor
[31]: https://github.com/Netflix/flamescope
[32]: https://github.com/jlukic

<!-- Examples -->

[100]: https://github.com/wyc/semantic-ui-react-todos
[101]: https://github.com/reactjs/redux/tree/master/examples/todos
