/*
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from "react";
import { Button as SemanticButton } from "semantic-ui-react";
import { GenericIcon } from "../icon";
/**
 * Icon button component.
 *
 * @param {IconButtonPropsInterface} props - Props injected to the component.
 *
 * @return {React.ReactElement}
 */
export const IconButton = (props) => {
    const { children, customIcon, customIconPosition, customIconSize, ["data-testid"]: testId } = props;
    return (React.createElement(SemanticButton, Object.assign({}, props, { "data-testid": testId, negative: true }),
        customIcon && (React.createElement(GenericIcon, { icon: customIcon, size: customIconSize, transparent: true, spaced: "right", floated: customIconPosition, "data-testid": `${testId}-icon` })),
        children));
};
/**
 * Default props for the icon button component.
 */
IconButton.defaultProps = {
    customIconPosition: "left",
    "data-testid": "icon-button"
};
//# sourceMappingURL=icon-button.js.map