/**
 * Copyright (c) 2021, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import classNames from "classnames";
import React from "react";
import { Dropdown, Item } from "semantic-ui-react";
import NineDotsIcon from "../../../assets/images/icons/nine-dots-icon.svg";
import { GenericIcon } from "../../icon";
import { Tooltip } from "../../typography";
/**
 * App Switcher component to switch between apps.
 */
export const AppSwitcher = (props) => {
    const { apps, enabled, className, tooltip, tooltipOptions, triggerIcon, ["data-testid"]: testId } = props, rest = __rest(props, ["apps", "enabled", "className", "tooltip", "tooltipOptions", "triggerIcon", "data-testid"]);
    const classes = classNames("header-dropdown", "app-switch-dropdown", className);
    /**
     * Stops the dropdown from closing on click.
     *
     * @param { React.SyntheticEvent<HTMLElement> } e - Click event.
     */
    const handleDropdownClick = (e) => {
        e.stopPropagation();
    };
    return (React.createElement(React.Fragment, null, enabled && (React.createElement(Tooltip, Object.assign({ compact: true, disabled: tooltip === undefined, trigger: (React.createElement(Dropdown, Object.assign({ icon: triggerIcon !== null && triggerIcon !== void 0 ? triggerIcon : (React.createElement(GenericIcon, { inverted: true, transparent: true, hoverable: true, hoverType: "circular", icon: NineDotsIcon, fill: "white", size: "auto" })), className: classes, "data-testid": testId }, rest), React.createElement(Dropdown.Menu, { pointing: true, className: "header-dropdown-menu", onClick: handleDropdownClick }, (apps && Array.isArray(apps) && apps.length > 0) && (apps.map((app, index) => {
            const { enabled, icon, name, description } = app, appRest = __rest(app, ["enabled", "icon", "name", "description"]);
            if (!enabled) {
                return null;
            }
            return (React.createElement(React.Fragment, null,
                React.createElement(Dropdown.Item, Object.assign({ key: index, className: "header-dropdown-item" }, appRest),
                    React.createElement(Item, { className: "header-dropdown-item-inner flex" },
                        React.createElement(GenericIcon, { "data-testid": `${appRest["data-testid"]}-icon`, inline: true, transparent: true, icon: icon, size: "x30", spaced: "right" }),
                        React.createElement(Item.Content, { verticalAlign: "middle" },
                            React.createElement(Item.Header, { "data-testid": `${appRest["data-testid"]}-name` }, name),
                            React.createElement(Item.Meta, { "data-testid": `${appRest["data-testid"]}-description` }, description)))),
                (index !== (apps.length - 1)) && (React.createElement(Dropdown.Divider, null))));
        }))))), content: tooltip, size: "mini" }, tooltipOptions)))));
};
/**
 * Default props for the component.
 */
AppSwitcher.defaultProps = {
    "data-testid": "app-switcher",
    enabled: true,
    floating: true,
    item: true,
    pointing: "top right",
    tooltip: "Apps"
};
//# sourceMappingURL=app-switcher.js.map